import React, { createContext, useState, useContext } from 'react';

const PanierContext = createContext();

export const PanierProvider = ({ children }) => {
    const [panier, setPanier] = useState([]);

    // Ajouter un produit ou augmenter sa quantité
    const ajouterAuPanier = (produit) => {
        setPanier((prevPanier) => {
            const existe = prevPanier.find(item => item.id === produit.id);
            if (existe) {
                return prevPanier.map(item =>
                    item.id === produit.id
                        ? { ...item, quantite: item.quantite + (produit.quantite || 1) }
                        : item
                );
            }
            return [...prevPanier, { ...produit, quantite: produit.quantite || 1 }];
        });
    };

    const modifierQuantite = (id, delta) => {
        setPanier((prevPanier) =>
            prevPanier.map((item) => {
                if (item.id === id) {
                    const nouvelleQuantite = item.quantite + delta;
                    // On retourne l'item avec la nouvelle quantité (minimum 1)
                    return { ...item, quantite: nouvelleQuantite < 1 ? 1 : nouvelleQuantite };
                }
                return item;
            })
        );
    };

    // Supprimer complètement un article du panier
    const supprimerDuPanier = (id) => {
        setPanier(prevPanier => prevPanier.filter(item => item.id !== id));
    };

    const viderPanier = () => setPanier([]);

    return (
        <PanierContext.Provider value={{
            panier,
            ajouterAuPanier,
            modifierQuantite,
            supprimerDuPanier,
            viderPanier
        }}>
            {children}
        </PanierContext.Provider>
    );
};

export const usePanier = () => useContext(PanierContext);