import { Header } from "../message/SupportingTypes";
export interface WebhookRequestTriggers {
    Open?: OpenWebhookTrigger;
    Click?: WebhookTrigger;
    Delivery?: WebhookTrigger;
    Bounce?: BounceWebhookTrigger;
    SpamComplaint?: SpamWebhookTrigger;
    SubscriptionChange?: WebhookTrigger;
}
export declare class UpdateWebhookRequest {
    Url?: string;
    HttpAuth?: HttpAuth;
    HttpHeaders?: Header[];
    Triggers?: WebhookRequestTriggers;
    constructor(url?: string, triggers?: WebhookRequestTriggers, httpAuth?: HttpAuth, httpHeaders?: Header[]);
}
export declare class CreateWebhookRequest extends UpdateWebhookRequest {
    MessageStream?: string;
    constructor(url?: string, triggers?: WebhookRequestTriggers, httpAuth?: HttpAuth, httpHeaders?: Header[], messageStream?: string);
}
export interface WebhookTrigger {
    Enabled: boolean;
}
export interface OpenWebhookTrigger extends WebhookTrigger {
    PostFirstOpenOnly?: boolean;
}
export interface BounceWebhookTrigger extends WebhookTrigger {
    IncludeContent?: boolean;
}
export interface SpamWebhookTrigger extends WebhookTrigger {
    IncludeContent?: boolean;
}
export interface HttpAuth {
    Username: string;
    Password: string;
}
export interface Webhook {
    ID: number;
    Url: string;
    HttpAuth?: HttpAuth;
    HttpHeaders?: Header[];
    MessageStream: string;
    Triggers: {
        Open: OpenWebhookTrigger;
        Click: WebhookTrigger;
        Delivery: WebhookTrigger;
        Bounce: BounceWebhookTrigger;
        SpamComplaint: SpamWebhookTrigger;
        SubscriptionChange: WebhookTrigger;
    };
}
