"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TemplateFilteringParameters = exports.TemplatedMessage = exports.TemplatesPushRequest = exports.TemplateTypes = exports.TemplateValidationOptions = exports.CreateTemplateRequest = exports.UpdateTemplateRequest = void 0;
var FilteringParameters_1 = require("../client/FilteringParameters");
var UpdateTemplateRequest = /** @class */ (function () {
    function UpdateTemplateRequest(Name, Subject, HtmlBody, TextBody, Alias, TemplateType, LayoutTemplate) {
        this.Name = Name;
        this.Subject = Subject;
        this.HtmlBody = HtmlBody;
        this.TextBody = TextBody;
        this.Alias = Alias;
        this.LayoutTemplate = LayoutTemplate;
        this.TemplateType = TemplateType;
    }
    return UpdateTemplateRequest;
}());
exports.UpdateTemplateRequest = UpdateTemplateRequest;
var CreateTemplateRequest = /** @class */ (function (_super) {
    __extends(CreateTemplateRequest, _super);
    function CreateTemplateRequest(Name, Subject, HtmlBody, TextBody, Alias, TemplateType, LayoutTemplate) {
        return _super.call(this, Name, Subject, HtmlBody, TextBody, Alias, TemplateType, LayoutTemplate) || this;
    }
    return CreateTemplateRequest;
}(UpdateTemplateRequest));
exports.CreateTemplateRequest = CreateTemplateRequest;
var TemplateValidationOptions = /** @class */ (function () {
    function TemplateValidationOptions(Subject, HtmlBody, TextBody, TestRenderModel, TemplateType, LayoutTemplate, InlineCssForHtmlTestRender) {
        this.Subject = Subject;
        this.HtmlBody = HtmlBody;
        this.TextBody = TextBody;
        this.TestRenderModel = TestRenderModel;
        this.TemplateType = TemplateType;
        this.LayoutTemplate = LayoutTemplate;
        this.InlineCssForHtmlTestRender = InlineCssForHtmlTestRender;
    }
    return TemplateValidationOptions;
}());
exports.TemplateValidationOptions = TemplateValidationOptions;
var TemplateTypes;
(function (TemplateTypes) {
    TemplateTypes["Standard"] = "Standard";
    TemplateTypes["Layout"] = "Layout";
})(TemplateTypes = exports.TemplateTypes || (exports.TemplateTypes = {}));
var TemplatesPushRequest = /** @class */ (function () {
    function TemplatesPushRequest(SourceServerID, DestinationServerID, PerformChanges) {
        this.SourceServerID = SourceServerID;
        this.DestinationServerID = DestinationServerID;
        this.PerformChanges = PerformChanges;
    }
    return TemplatesPushRequest;
}());
exports.TemplatesPushRequest = TemplatesPushRequest;
var TemplatedMessage = /** @class */ (function () {
    function TemplatedMessage(from, templateIdOrAlias, templateModel, to, cc, bcc, replyTo, tag, trackOpens, trackLinks, headers, attachments) {
        this.From = from;
        this.TemplateModel = templateModel;
        if (typeof templateIdOrAlias === "number") {
            this.TemplateId = templateIdOrAlias;
        }
        else {
            this.TemplateAlias = templateIdOrAlias;
        }
        this.To = to;
        this.Cc = cc;
        this.Bcc = bcc;
        this.ReplyTo = replyTo;
        this.Tag = tag;
        this.TrackOpens = trackOpens;
        this.TrackLinks = trackLinks;
        this.Headers = headers;
        this.Attachments = attachments;
    }
    return TemplatedMessage;
}());
exports.TemplatedMessage = TemplatedMessage;
/**
 * Describes filtering parameters that can be used when retrieving templates.
 * When pagination parameters are not specified, default values are set.
 */
var TemplateFilteringParameters = /** @class */ (function (_super) {
    __extends(TemplateFilteringParameters, _super);
    function TemplateFilteringParameters(count, offset, templateType, layoutTemplate) {
        if (count === void 0) { count = 100; }
        if (offset === void 0) { offset = 0; }
        var _this = _super.call(this, count, offset) || this;
        _this.templateType = templateType;
        _this.layoutTemplate = layoutTemplate;
        return _this;
    }
    return TemplateFilteringParameters;
}(FilteringParameters_1.FilteringParameters));
exports.TemplateFilteringParameters = TemplateFilteringParameters;
//# sourceMappingURL=Template.js.map