import { FilteringParameters } from "../client/FilteringParameters";
import { Hash } from "../client/SupportingTypes";
import { Attachment, Header, LinkTrackingOptions } from "../message/SupportingTypes";
export declare class UpdateTemplateRequest {
    TemplateType?: TemplateTypes;
    Name?: string;
    Subject?: string;
    HtmlBody?: string;
    TextBody?: string;
    Alias?: string | null;
    LayoutTemplate?: string;
    constructor(Name?: string, Subject?: string, HtmlBody?: string, TextBody?: string, Alias?: string | null, TemplateType?: TemplateTypes, LayoutTemplate?: string);
}
export declare class CreateTemplateRequest extends UpdateTemplateRequest {
    constructor(Name: string, Subject?: string, HtmlBody?: string, TextBody?: string, Alias?: string | null, TemplateType?: TemplateTypes, LayoutTemplate?: string);
}
export declare class TemplateValidationOptions {
    Subject?: string;
    HtmlBody?: string;
    TextBody?: string;
    TestRenderModel?: object;
    TemplateType?: TemplateTypes;
    LayoutTemplate?: string;
    InlineCssForHtmlTestRender?: boolean;
    constructor(Subject?: string, HtmlBody?: string, TextBody?: string, TestRenderModel?: object, TemplateType?: TemplateTypes, LayoutTemplate?: string, InlineCssForHtmlTestRender?: boolean);
}
export declare enum TemplateTypes {
    Standard = "Standard",
    Layout = "Layout"
}
export interface Template {
    TemplateType: TemplateTypes;
    Name: string;
    TemplateId: number;
    Alias: string | null;
    Subject: string;
    HtmlBody: string | null;
    TextBody: string | null;
    Active: boolean;
    AssociatedServerId: number;
    LayoutTemplate: string | null;
}
export interface TemplateInList {
    TemplateType: TemplateTypes;
    Active: boolean;
    TemplateId: number;
    Name: string;
    Alias: string | null;
    LayoutTemplate: string | null;
}
export interface Templates {
    TotalCount: number;
    Templates: TemplateInList[];
}
export declare class TemplatesPushRequest {
    SourceServerID: number;
    DestinationServerID: number;
    PerformChanges: boolean;
    constructor(SourceServerID: number, DestinationServerID: number, PerformChanges: boolean);
}
export interface TemplatePushAction {
    Action: string;
    TemplateId?: number;
    Alias: string;
    Name: string;
}
export interface TemplatesPush {
    TotalCount: number;
    Templates: TemplatePushAction[];
}
export interface ValidationSection {
    ContentIsValid: boolean;
    ValidationErrors: object;
    RenderedContent: string;
}
export interface TemplateValidation {
    AllContentIsValid: boolean;
    HtmlBody: ValidationSection;
    TextBody: ValidationSection;
    Subject: ValidationSection;
    SuggestedTemplateModel: object;
}
export declare class TemplatedMessage {
    TemplateId?: number;
    TemplateAlias?: string;
    TemplateModel: object;
    InlineCss?: boolean;
    From: string;
    To?: string;
    Cc?: string;
    Bcc?: string;
    ReplyTo?: string;
    MessageStream?: string;
    Tag?: string;
    TrackOpens?: boolean;
    TrackLinks?: LinkTrackingOptions;
    Headers?: Header[];
    Metadata?: Hash<string>;
    Attachments?: Attachment[];
    constructor(from: string, templateIdOrAlias: (number | string), templateModel: object, to?: string, cc?: string, bcc?: string, replyTo?: string, tag?: string, trackOpens?: boolean, trackLinks?: LinkTrackingOptions, headers?: Header[], attachments?: Attachment[]);
}
/**
 * Describes filtering parameters that can be used when retrieving templates.
 * When pagination parameters are not specified, default values are set.
 */
export declare class TemplateFilteringParameters extends FilteringParameters {
    templateType?: TemplateTypes;
    layoutTemplate?: string;
    constructor(count?: number, offset?: number, templateType?: TemplateTypes, layoutTemplate?: string);
}
