import { FilteringParameters } from "../client/FilteringParameters";
export declare enum SuppressionReason {
    HardBounce = "HardBounce",
    SpamComplaint = "SpamComplaint",
    ManualSuppression = "ManualSuppression"
}
export declare enum SuppressionOrigin {
    Recipient = "Recipient",
    Customer = "Customer",
    Admin = "Admin"
}
/**
 * Describes filtering parameters that can be used when retrieving bounces.
 * When pagination parameters are not specified, default values are set.
 */
export declare class SuppressionFilteringParameters extends FilteringParameters {
    suppressionReason?: SuppressionReason;
    origin?: SuppressionOrigin;
    toDate?: string;
    fromDate?: string;
    emailAddress?: string;
    constructor(count?: number, offset?: number, suppressionReason?: SuppressionReason, origin?: SuppressionOrigin, emailAddress?: string, fromDate?: string, toDate?: string);
}
