export declare enum UnsubscribeHandlingTypes {
    None = "None",
    Postmark = "Postmark",
    Custom = "Custom"
}
export interface SubscriptionManagementConfiguration {
    UnsubscribeHandlingType: UnsubscribeHandlingTypes;
}
export interface MessageStream {
    ID: string;
    ServerID: number;
    Name: string;
    Description: string;
    MessageStreamType: string;
    CreatedAt: string;
    UpdatedAt?: string;
    ArchivedAt?: string;
    ExpectedPurgeDate?: string;
    SubscriptionManagementConfiguration: SubscriptionManagementConfiguration;
}
export interface MessageStreams {
    MessageStreams: MessageStream[];
    TotalCount: number;
}
export interface MessageStreamArchiveResponse {
    ID: number;
    ServerID: number;
    ExpectedPurgeDate: string;
}
export interface MessageStreamUnarchiveResponse {
    ID: string;
    ServerID: number;
    Name: string;
    Description: string;
    MessageStreamType: string;
    CreatedAt: string;
    UpdatedAt?: string;
    ArchivedAt?: null;
    ExpectedPurgeDate?: string;
    SubscriptionManagementConfiguration: SubscriptionManagementConfiguration;
}
export declare class UpdateMessageStreamRequest {
    Name?: string;
    Description?: string;
    SubscriptionManagementConfiguration?: SubscriptionManagementConfiguration;
    constructor(name?: string, description?: string, subscriptionManagementConfiguration?: SubscriptionManagementConfiguration);
}
export declare class CreateMessageStreamRequest {
    ID: string;
    Name: string;
    MessageStreamType: string;
    Description?: string;
    SubscriptionManagementConfiguration?: SubscriptionManagementConfiguration;
    constructor(id: string, name: string, messageStreamType: string, description?: string, subscriptionManagementConfiguration?: SubscriptionManagementConfiguration);
}
