import { LinkTrackingOptions, ServerDeliveryTypes } from "../message/SupportingTypes";
export interface Server {
    ID: number;
    Name: string;
    ApiTokens: string[];
    ServerLink: string;
    Color: string;
    SmtpApiActivated: boolean;
    RawEmailEnabled: boolean;
    DeliveryType: ServerDeliveryTypes;
    InboundAddress: string;
    InboundHookUrl?: string;
    BounceHookUrl?: string;
    OpenHookUrl?: string;
    DeliveryHookUrl?: string;
    ClickHookUrl?: string;
    PostFirstOpenOnly: boolean;
    InboundDomain?: string;
    InboundHash: string;
    InboundSpamThreshold: number;
    TrackOpens?: boolean;
    TrackLinks: LinkTrackingOptions;
    IncludeBounceContentInHook: boolean;
    EnableSmtpApiErrorHooks: boolean;
}
export declare class UpdateServerRequest {
    Name?: string;
    Color?: string;
    SmtpApiActivated?: boolean;
    RawEmailEnabled?: boolean;
    InboundHookUrl?: string;
    InboundDomain?: string;
    BounceHookUrl?: string;
    OpenHookUrl?: string;
    DeliveryHookUrl?: string;
    ClickHookUrl?: string;
    PostFirstOpenOnly?: boolean;
    InboundSpamThreshold?: number;
    TrackOpens?: boolean;
    TrackLinks?: LinkTrackingOptions;
    IncludeBounceContentInHook?: boolean;
    EnableSmtpApiErrorHooks?: boolean;
    constructor(Name?: string, Color?: string, SmtpApiActivated?: boolean, RawEmailEnabled?: boolean, InboundHookUrl?: string, BounceHookUrl?: string, OpenHookUrl?: string, DeliveryHookUrl?: string, ClickHookUrl?: string, PostFirstOpenOnly?: boolean, InboundSpamThreshold?: number, TrackOpens?: boolean, TrackLinks?: LinkTrackingOptions, IncludeBounceContentInHook?: boolean, EnableSmtpApiErrorHooks?: boolean, InboundDomain?: string);
}
export declare class CreateServerRequest extends UpdateServerRequest {
    DeliveryType?: ServerDeliveryTypes;
    constructor(Name: string, Color?: string, SmtpApiActivated?: boolean, RawEmailEnabled?: boolean, InboundHookUrl?: string, BounceHookUrl?: string, OpenHookUrl?: string, DeliveryHookUrl?: string, ClickHookUrl?: string, PostFirstOpenOnly?: boolean, InboundSpamThreshold?: number, TrackOpens?: boolean, TrackLinks?: LinkTrackingOptions, IncludeBounceContentInHook?: boolean, EnableSmtpApiErrorHooks?: boolean, InboundDomain?: string, DeliveryType?: ServerDeliveryTypes);
}
