import { DomainDetails } from "../domains/Domain";
export interface Signature {
    ID: number;
    Name: string;
    Confirmed: boolean;
    Domain: string;
    EmailAddress: string;
    ReplyToEmailAddress: string;
}
export interface SignatureDetails extends DomainDetails {
    Domain: string;
    EmailAddress: string;
    ReplyToEmailAddress: string;
    Confirmed: boolean;
    ConfirmationPersonalNote: string;
}
export interface Signatures {
    TotalCount: number;
    SenderSignatures: Signature[];
}
export declare class UpdateSignatureRequest {
    Name: string;
    ReplyToEmail?: string;
    ReturnPathDomain?: string;
    ConfirmationPersonalNote?: string;
    constructor(Name: string, ReplyToEmail?: string, ReturnPathDomain?: string, ConfirmationPersonalNote?: string);
}
export declare class CreateSignatureRequest {
    Name?: string;
    FromEmail: string;
    ReplyToEmail?: string;
    ReturnPathDomain?: string;
    ConfirmationPersonalNote?: string;
    constructor(Name: string, FromEmail: string, ReplyToEmail?: string, ReturnPathDomain?: string, ConfirmationPersonalNote?: string);
}
