"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutboundMessageClicksFilteringParameters = exports.OutboundMessageOpensFilteringParameters = exports.OutboundMessageTrackingFilteringParameters = exports.InboundMessagesFilteringParameters = exports.OutboundMessagesFilteringParameters = exports.InboundMessageStatus = exports.OutboundMessageStatus = void 0;
var FilteringParameters_1 = require("../client/FilteringParameters");
var OutboundMessageStatus;
(function (OutboundMessageStatus) {
    OutboundMessageStatus["Queued"] = "queued";
    OutboundMessageStatus["Sent"] = "sent";
    OutboundMessageStatus["Processed"] = "processed";
})(OutboundMessageStatus = exports.OutboundMessageStatus || (exports.OutboundMessageStatus = {}));
var InboundMessageStatus;
(function (InboundMessageStatus) {
    InboundMessageStatus["Queued"] = "queued";
    InboundMessageStatus["Sent"] = "sent";
    InboundMessageStatus["Processed"] = "processed";
    InboundMessageStatus["Blocked"] = "blocked";
    InboundMessageStatus["Failed"] = "failed";
    InboundMessageStatus["Scheduled"] = "scheduled";
})(InboundMessageStatus = exports.InboundMessageStatus || (exports.InboundMessageStatus = {}));
/**
 * Describes filtering parameters that can be used when retrieving outbound messages.
 * When pagination parameters are not specified, default values are set.
 */
var OutboundMessagesFilteringParameters = /** @class */ (function (_super) {
    __extends(OutboundMessagesFilteringParameters, _super);
    function OutboundMessagesFilteringParameters(count, offset, recipient, fromEmail, tag, status, fromDate, toDate, subject, messageStream) {
        if (count === void 0) { count = 100; }
        if (offset === void 0) { offset = 0; }
        var _this = _super.call(this, count, offset) || this;
        _this.recipient = recipient;
        _this.fromEmail = fromEmail;
        _this.tag = tag;
        _this.status = status;
        _this.fromDate = fromDate;
        _this.toDate = toDate;
        _this.subject = subject;
        _this.messageStream = messageStream;
        return _this;
    }
    return OutboundMessagesFilteringParameters;
}(FilteringParameters_1.FilteringParameters));
exports.OutboundMessagesFilteringParameters = OutboundMessagesFilteringParameters;
/**
 * Describes filtering parameters that can be used when retrieving inbound messages.
 * When pagination parameters are not specified, default values are set.
 */
var InboundMessagesFilteringParameters = /** @class */ (function (_super) {
    __extends(InboundMessagesFilteringParameters, _super);
    function InboundMessagesFilteringParameters(count, offset, mailboxHash, recipient, fromEmail, tag, status, fromDate, toDate, subject) {
        if (count === void 0) { count = 100; }
        if (offset === void 0) { offset = 0; }
        var _this = _super.call(this, count, offset) || this;
        _this.status = status;
        _this.mailboxHash = mailboxHash;
        _this.recipient = recipient;
        _this.fromEmail = fromEmail;
        _this.tag = tag;
        _this.fromDate = fromDate;
        _this.toDate = toDate;
        _this.subject = subject;
        return _this;
    }
    return InboundMessagesFilteringParameters;
}(FilteringParameters_1.FilteringParameters));
exports.InboundMessagesFilteringParameters = InboundMessagesFilteringParameters;
/**
 * Describes filtering parameters that can be used when retrieving tracked outbound messages.
 * When pagination parameters are not specified, default values are set.
 */
var OutboundMessageTrackingFilteringParameters = /** @class */ (function (_super) {
    __extends(OutboundMessageTrackingFilteringParameters, _super);
    function OutboundMessageTrackingFilteringParameters(count, offset, recipient, tag, client_name, client_company, client_family, os_name, os_family, os_company, platform, country, region, city, messageStream) {
        if (count === void 0) { count = 100; }
        if (offset === void 0) { offset = 0; }
        var _this = _super.call(this, count, offset) || this;
        _this.recipient = recipient;
        _this.tag = tag;
        _this.client_name = client_name;
        _this.client_company = client_company;
        _this.client_family = client_family;
        _this.os_name = os_name;
        _this.os_family = os_family;
        _this.os_company = os_company;
        _this.platform = platform;
        _this.country = country;
        _this.region = region;
        _this.city = city;
        _this.messageStream = messageStream;
        return _this;
    }
    return OutboundMessageTrackingFilteringParameters;
}(FilteringParameters_1.FilteringParameters));
exports.OutboundMessageTrackingFilteringParameters = OutboundMessageTrackingFilteringParameters;
var OutboundMessageOpensFilteringParameters = /** @class */ (function (_super) {
    __extends(OutboundMessageOpensFilteringParameters, _super);
    function OutboundMessageOpensFilteringParameters() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return OutboundMessageOpensFilteringParameters;
}(OutboundMessageTrackingFilteringParameters));
exports.OutboundMessageOpensFilteringParameters = OutboundMessageOpensFilteringParameters;
var OutboundMessageClicksFilteringParameters = /** @class */ (function (_super) {
    __extends(OutboundMessageClicksFilteringParameters, _super);
    function OutboundMessageClicksFilteringParameters() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return OutboundMessageClicksFilteringParameters;
}(OutboundMessageTrackingFilteringParameters));
exports.OutboundMessageClicksFilteringParameters = OutboundMessageClicksFilteringParameters;
//# sourceMappingURL=MessageFilteringParameters.js.map