import { FilteringParameters } from "../client/FilteringParameters";
export declare enum OutboundMessageStatus {
    Queued = "queued",
    Sent = "sent",
    Processed = "processed"
}
export declare enum InboundMessageStatus {
    Queued = "queued",
    Sent = "sent",
    Processed = "processed",
    Blocked = "blocked",
    Failed = "failed",
    Scheduled = "scheduled"
}
/**
 * Describes filtering parameters that can be used when retrieving outbound messages.
 * When pagination parameters are not specified, default values are set.
 */
export declare class OutboundMessagesFilteringParameters extends FilteringParameters {
    recipient?: string;
    fromEmail?: string;
    tag?: string;
    status?: OutboundMessageStatus;
    fromDate?: string;
    toDate?: string;
    subject?: string;
    messageStream?: string;
    [key: string]: any;
    constructor(count?: number, offset?: number, recipient?: string, fromEmail?: string, tag?: string, status?: OutboundMessageStatus, fromDate?: string, toDate?: string, subject?: string, messageStream?: string);
}
/**
 * Describes filtering parameters that can be used when retrieving inbound messages.
 * When pagination parameters are not specified, default values are set.
 */
export declare class InboundMessagesFilteringParameters extends FilteringParameters {
    mailboxHash?: string;
    recipient?: string;
    fromEmail?: string;
    tag?: string;
    status?: InboundMessageStatus;
    fromDate?: string;
    toDate?: string;
    subject?: string;
    constructor(count?: number, offset?: number, mailboxHash?: string, recipient?: string, fromEmail?: string, tag?: string, status?: InboundMessageStatus, fromDate?: string, toDate?: string, subject?: string);
}
/**
 * Describes filtering parameters that can be used when retrieving tracked outbound messages.
 * When pagination parameters are not specified, default values are set.
 */
export declare class OutboundMessageTrackingFilteringParameters extends FilteringParameters {
    recipient?: string;
    tag?: string;
    client_name?: string;
    client_company?: string;
    client_family?: string;
    os_name?: string;
    os_family?: string;
    os_company?: string;
    platform?: string;
    country?: string;
    region?: string;
    city?: string;
    messageStream?: string;
    constructor(count?: number, offset?: number, recipient?: string, tag?: string, client_name?: string, client_company?: string, client_family?: string, os_name?: string, os_family?: string, os_company?: string, platform?: string, country?: string, region?: string, city?: string, messageStream?: string);
}
export declare class OutboundMessageOpensFilteringParameters extends OutboundMessageTrackingFilteringParameters {
}
export declare class OutboundMessageClicksFilteringParameters extends OutboundMessageTrackingFilteringParameters {
}
