"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Attachment = exports.Header = exports.ServerDeliveryTypes = exports.LinkClickLocation = exports.LinkTrackingOptions = void 0;
var LinkTrackingOptions;
(function (LinkTrackingOptions) {
    LinkTrackingOptions["TextOnly"] = "TextOnly";
    LinkTrackingOptions["HtmlOnly"] = "HtmlOnly";
    LinkTrackingOptions["HtmlAndText"] = "HtmlAndText";
    LinkTrackingOptions["None"] = "None";
})(LinkTrackingOptions = exports.LinkTrackingOptions || (exports.LinkTrackingOptions = {}));
var LinkClickLocation;
(function (LinkClickLocation) {
    LinkClickLocation["HTML"] = "HTML";
    LinkClickLocation["Text"] = "Text";
})(LinkClickLocation = exports.LinkClickLocation || (exports.LinkClickLocation = {}));
var ServerDeliveryTypes;
(function (ServerDeliveryTypes) {
    ServerDeliveryTypes["Live"] = "Live";
    ServerDeliveryTypes["Sandbox"] = "Sandbox";
})(ServerDeliveryTypes = exports.ServerDeliveryTypes || (exports.ServerDeliveryTypes = {}));
var Header = /** @class */ (function () {
    function Header(Name, Value) {
        this.Name = Name;
        this.Value = Value;
    }
    return Header;
}());
exports.Header = Header;
/**
 * Attachment content
 *
 * @param Name - name of the attachment, for example book.pdf
 * @param Content - Base64 encoded content, for example: fs.readFileSync('/Folder/book.pdf').toString('base64')
 * @param ContentID - id of the attachment, in case we are referencing it, for example: cid:123book.pdf
 * @param ContentType - content type (json, image, etc)
 * @param ContentLength - length of the message
 */
var Attachment = /** @class */ (function () {
    function Attachment(Name, Content, ContentType, ContentID, ContentLength, Disposition) {
        if (ContentID === void 0) { ContentID = null; }
        this.Name = Name;
        this.Content = Content;
        this.ContentType = ContentType;
        this.ContentID = ContentID;
        this.ContentLength = ContentLength;
        this.Disposition = Disposition;
    }
    return Attachment;
}());
exports.Attachment = Attachment;
//# sourceMappingURL=SupportingTypes.js.map