export declare enum LinkTrackingOptions {
    TextOnly = "TextOnly",
    HtmlOnly = "HtmlOnly",
    HtmlAndText = "HtmlAndText",
    None = "None"
}
export declare enum LinkClickLocation {
    HTML = "HTML",
    Text = "Text"
}
export declare enum ServerDeliveryTypes {
    Live = "Live",
    Sandbox = "Sandbox"
}
export declare class Header {
    Name: string;
    Value: string;
    constructor(Name: string, Value: string);
}
/**
 * Attachment content
 *
 * @param Name - name of the attachment, for example book.pdf
 * @param Content - Base64 encoded content, for example: fs.readFileSync('/Folder/book.pdf').toString('base64')
 * @param ContentID - id of the attachment, in case we are referencing it, for example: cid:123book.pdf
 * @param ContentType - content type (json, image, etc)
 * @param ContentLength - length of the message
 */
export declare class Attachment {
    Name: string;
    ContentID: string | null;
    Content: string;
    ContentType: string;
    ContentLength?: number;
    Disposition?: string | null;
    constructor(Name: string, Content: string, ContentType: string, ContentID?: string | null, ContentLength?: number, Disposition?: string);
}
