import { DefaultResponse } from "../client/DefaultResponse";
import { Hash } from "../client/SupportingTypes";
import { Attachment, Header, LinkTrackingOptions } from "../message/SupportingTypes";
export declare class Message {
    From: string;
    To?: string;
    Cc?: string;
    Bcc?: string;
    MessageStream?: string;
    Subject: string;
    ReplyTo?: string;
    HtmlBody?: string;
    TextBody?: string;
    Tag?: string;
    TrackOpens?: boolean;
    TrackLinks?: LinkTrackingOptions;
    Headers?: Header[];
    Attachments?: Attachment[];
    Metadata?: Hash<string>;
    constructor(From: string, Subject: string, HtmlBody?: string, TextBody?: string, To?: string, Cc?: string, Bcc?: string, ReplyTo?: string, Tag?: string, TrackOpens?: boolean, TrackLinks?: LinkTrackingOptions, Headers?: Header[], Attachments?: Attachment[], Metadata?: Hash<string>);
}
export interface MessageSendingResponse extends DefaultResponse {
    To?: string;
    Cc?: string;
    Bcc?: string;
    SubmittedAt: string;
    MessageID: string;
}
