"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpClient = void 0;
var HttpClient = /** @class */ (function () {
    function HttpClient(configOptions) {
        this.clientOptions = __assign(__assign({}, HttpClient.DefaultOptions), configOptions);
        this.initHttpClient(this.clientOptions);
    }
    HttpClient.prototype.getBaseHttpRequestURL = function () {
        var scheme = this.clientOptions.useHttps ? "https" : "http";
        return "".concat(scheme, "://").concat(this.clientOptions.requestHost);
    };
    /**
     * Http Client connection configuration options.
     * You may modify these values and new clients will use them.
     * Any values provided to a Client constructor will override default options.
     */
    HttpClient.DefaultOptions = {
        useHttps: true,
        requestHost: "api.postmarkapp.com",
        timeout: 180,
    };
    return HttpClient;
}());
exports.HttpClient = HttpClient;
//# sourceMappingURL=HttpClient.js.map