import { ClientOptions } from "./ClientOptions";
export declare abstract class HttpClient {
    /**
     * Http Client connection configuration options.
     * You may modify these values and new clients will use them.
     * Any values provided to a Client constructor will override default options.
     */
    static DefaultOptions: ClientOptions.Configuration;
    clientOptions: ClientOptions.Configuration;
    client: any;
    protected constructor(configOptions?: ClientOptions.Configuration);
    getBaseHttpRequestURL(): string;
    abstract initHttpClient(configOptions?: ClientOptions.Configuration): void;
    abstract httpRequest<T>(method: ClientOptions.HttpMethod, path: string, queryParameters: object, body: (null | object), headers: any): Promise<T>;
}
