"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientOptions = void 0;
var ClientOptions;
(function (ClientOptions) {
    var Configuration = /** @class */ (function () {
        function Configuration(useHttps, requestHost, timeout) {
            this.useHttps = useHttps;
            this.requestHost = requestHost;
            this.timeout = timeout;
        }
        return Configuration;
    }());
    ClientOptions.Configuration = Configuration;
    var HttpMethod;
    (function (HttpMethod) {
        HttpMethod["GET"] = "GET";
        HttpMethod["POST"] = "POST";
        HttpMethod["DELETE"] = "DELETE";
        HttpMethod["PUT"] = "PUT";
        HttpMethod["OPTIONS"] = "OPTIONS";
        HttpMethod["HEAD"] = "HEAD";
        HttpMethod["PATCH"] = "PATCH";
    })(HttpMethod = ClientOptions.HttpMethod || (ClientOptions.HttpMethod = {}));
    var AuthHeaderNames;
    (function (AuthHeaderNames) {
        AuthHeaderNames["SERVER_TOKEN"] = "X-Postmark-Server-Token";
        AuthHeaderNames["ACCOUNT_TOKEN"] = "X-Postmark-Account-Token";
    })(AuthHeaderNames = ClientOptions.AuthHeaderNames || (ClientOptions.AuthHeaderNames = {}));
})(ClientOptions = exports.ClientOptions || (exports.ClientOptions = {}));
//# sourceMappingURL=ClientOptions.js.map