"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidEmailRequestError = exports.InactiveRecipientsError = exports.ApiInputError = exports.UnknownError = exports.RateLimitExceededError = exports.ServiceUnavailablerError = exports.InternalServerError = exports.InvalidAPIKeyError = exports.HttpError = exports.PostmarkError = void 0;
/**
 * Standard Postmark error on which all sub-errors are based.
 */
var PostmarkError = /** @class */ (function (_super) {
    __extends(PostmarkError, _super);
    function PostmarkError(message, code, statusCode) {
        if (code === void 0) { code = 0; }
        if (statusCode === void 0) { statusCode = 0; }
        var _this = _super.call(this, message) || this;
        _this.statusCode = statusCode;
        _this.code = code;
        // this is mandatory due:
        // https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
        Object.setPrototypeOf(_this, PostmarkError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    PostmarkError.prototype.setUpStackTrace = function () {
        this.name = this.constructor.name;
        Error.captureStackTrace(this, this.constructor);
    };
    return PostmarkError;
}(Error));
exports.PostmarkError = PostmarkError;
var HttpError = /** @class */ (function (_super) {
    __extends(HttpError, _super);
    function HttpError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, HttpError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    return HttpError;
}(PostmarkError));
exports.HttpError = HttpError;
var InvalidAPIKeyError = /** @class */ (function (_super) {
    __extends(InvalidAPIKeyError, _super);
    function InvalidAPIKeyError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, InvalidAPIKeyError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    return InvalidAPIKeyError;
}(HttpError));
exports.InvalidAPIKeyError = InvalidAPIKeyError;
var InternalServerError = /** @class */ (function (_super) {
    __extends(InternalServerError, _super);
    function InternalServerError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, InternalServerError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    return InternalServerError;
}(HttpError));
exports.InternalServerError = InternalServerError;
var ServiceUnavailablerError = /** @class */ (function (_super) {
    __extends(ServiceUnavailablerError, _super);
    function ServiceUnavailablerError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, ServiceUnavailablerError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    return ServiceUnavailablerError;
}(HttpError));
exports.ServiceUnavailablerError = ServiceUnavailablerError;
var RateLimitExceededError = /** @class */ (function (_super) {
    __extends(RateLimitExceededError, _super);
    function RateLimitExceededError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, RateLimitExceededError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    return RateLimitExceededError;
}(HttpError));
exports.RateLimitExceededError = RateLimitExceededError;
var UnknownError = /** @class */ (function (_super) {
    __extends(UnknownError, _super);
    function UnknownError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, UnknownError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    return UnknownError;
}(HttpError));
exports.UnknownError = UnknownError;
var ApiInputError = /** @class */ (function (_super) {
    __extends(ApiInputError, _super);
    function ApiInputError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, ApiInputError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    ApiInputError.buildSpecificError = function (message, code, statusCode) {
        switch (code) {
            case this.ERROR_CODES.inactiveRecipient:
                return new InactiveRecipientsError(message, code, statusCode);
            case this.ERROR_CODES.invalidEmailRequest:
                return new InvalidEmailRequestError(message, code, statusCode);
            default:
                return new ApiInputError(message, code, statusCode);
        }
    };
    ApiInputError.ERROR_CODES = {
        inactiveRecipient: 406,
        invalidEmailRequest: 300
    };
    return ApiInputError;
}(HttpError));
exports.ApiInputError = ApiInputError;
var InactiveRecipientsError = /** @class */ (function (_super) {
    __extends(InactiveRecipientsError, _super);
    function InactiveRecipientsError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, InactiveRecipientsError.prototype);
        _this.setUpStackTrace();
        _this.recipients = InactiveRecipientsError.parseInactiveRecipients(message);
        return _this;
    }
    InactiveRecipientsError.parseInactiveRecipients = function (message) {
        var result = [];
        this.inactiveRecipientsPatterns.some(function (pattern) {
            var regexResult = message.match(pattern);
            if (regexResult !== null) {
                result = regexResult[1].split(',').map(function (element) { return element.trim(); });
                return result;
            }
            else {
                result = [];
            }
        });
        return result;
    };
    InactiveRecipientsError.inactiveRecipientsPatterns = [
        /Found inactive addresses: (.+?)\.? Inactive/,
        /these inactive addresses: (.+?)\.?$/
    ];
    return InactiveRecipientsError;
}(ApiInputError));
exports.InactiveRecipientsError = InactiveRecipientsError;
var InvalidEmailRequestError = /** @class */ (function (_super) {
    __extends(InvalidEmailRequestError, _super);
    function InvalidEmailRequestError(message, code, statusCode) {
        var _this = _super.call(this, message, code, statusCode) || this;
        Object.setPrototypeOf(_this, InvalidEmailRequestError.prototype);
        _this.setUpStackTrace();
        return _this;
    }
    return InvalidEmailRequestError;
}(ApiInputError));
exports.InvalidEmailRequestError = InvalidEmailRequestError;
//# sourceMappingURL=Errors.js.map