/**
 * Standard Postmark error on which all sub-errors are based.
 */
export declare class PostmarkError extends Error {
    code: number;
    statusCode: number;
    constructor(message: string, code?: number, statusCode?: number);
    protected setUpStackTrace(): void;
}
export declare class HttpError extends PostmarkError {
    constructor(message: string, code: number, statusCode: number);
}
export declare class InvalidAPIKeyError extends HttpError {
    constructor(message: string, code: number, statusCode: number);
}
export declare class InternalServerError extends HttpError {
    constructor(message: string, code: number, statusCode: number);
}
export declare class ServiceUnavailablerError extends HttpError {
    constructor(message: string, code: number, statusCode: number);
}
export declare class RateLimitExceededError extends HttpError {
    constructor(message: string, code: number, statusCode: number);
}
export declare class UnknownError extends HttpError {
    constructor(message: string, code: number, statusCode: number);
}
export declare class ApiInputError extends HttpError {
    static ERROR_CODES: {
        inactiveRecipient: number;
        invalidEmailRequest: number;
    };
    constructor(message: string, code: number, statusCode: number);
    static buildSpecificError(message: string, code: number, statusCode: number): ApiInputError;
}
export declare class InactiveRecipientsError extends ApiInputError {
    static inactiveRecipientsPatterns: RegExp[];
    recipients: string[];
    constructor(message: string, code: number, statusCode: number);
    static parseInactiveRecipients(message: string): string[];
}
export declare class InvalidEmailRequestError extends ApiInputError {
    constructor(message: string, code: number, statusCode: number);
}
