"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorHandler = void 0;
var Errors = require("./Errors");
/**
 * Handles general errors and all client request errors.
 * Client response errors are classified so that proper response error is generated.
 */
var ErrorHandler = /** @class */ (function () {
    function ErrorHandler() {
    }
    /**
     * Build general Postmark error.
     *
     * @param errorMessage - error message that needs to be identified and transformed to proper Postmark error.
     *
     * @returns properly formatted Postmark error.
     */
    ErrorHandler.prototype.buildError = function (errorMessage, code, statusCode) {
        if (code === void 0) { code = 0; }
        if (statusCode === void 0) { statusCode = 0; }
        if (statusCode === 0 && code === 0) {
            return new Errors.PostmarkError(errorMessage);
        }
        else {
            return this.buildErrorByHttpStatusCode(errorMessage, code, statusCode);
        }
    };
    /**
     * Build Postmark error based on HTTP request status.
     *
     * @param error - http request library error, that will be transformed to Postmark error.
     *
     * @returns properly formatted Postmark error.
     */
    ErrorHandler.prototype.buildErrorByHttpStatusCode = function (errorMessage, errorCode, errorStatusCode) {
        switch (errorStatusCode) {
            case 401:
                return new Errors.InvalidAPIKeyError(errorMessage, errorCode, errorStatusCode);
            case 404:
                return new Errors.PostmarkError(errorMessage, errorCode, errorStatusCode);
            case 422:
                return Errors.ApiInputError.buildSpecificError(errorMessage, errorCode, errorStatusCode);
            case 429:
                return new Errors.RateLimitExceededError(errorMessage, errorCode, errorStatusCode);
            case 500:
                return new Errors.InternalServerError(errorMessage, errorCode, errorStatusCode);
            case 503:
                return new Errors.ServiceUnavailablerError(errorMessage, errorCode, errorStatusCode);
            default:
                return new Errors.UnknownError(errorMessage, errorCode, errorStatusCode);
        }
    };
    return ErrorHandler;
}());
exports.ErrorHandler = ErrorHandler;
//# sourceMappingURL=ErrorHandler.js.map