import * as Errors from "./Errors";
/**
 * Handles general errors and all client request errors.
 * Client response errors are classified so that proper response error is generated.
 */
export declare class ErrorHandler {
    /**
     * Build general Postmark error.
     *
     * @param errorMessage - error message that needs to be identified and transformed to proper Postmark error.
     *
     * @returns properly formatted Postmark error.
     */
    buildError(errorMessage: string, code?: number, statusCode?: number): Errors.PostmarkError | Errors.HttpError;
    /**
     * Build Postmark error based on HTTP request status.
     *
     * @param error - http request library error, that will be transformed to Postmark error.
     *
     * @returns properly formatted Postmark error.
     */
    private buildErrorByHttpStatusCode;
}
