"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var BaseClient_1 = require("./BaseClient");
var index_1 = require("./models/index");
var index_2 = require("./models/index");
/**
 * Server client class that can be used to interact with an individual Postmark Server.
 */
var ServerClient = /** @class */ (function (_super) {
    __extends(ServerClient, _super);
    /**
     * Create a client.
     *
     * @param serverToken - The token for the server that you wish to interact with.
     * @param configOptions - Options to customize the behavior of the this client.
     */
    function ServerClient(serverToken, configOptions) {
        return _super.call(this, serverToken, index_1.ClientOptions.AuthHeaderNames.SERVER_TOKEN, configOptions) || this;
    }
    /** Send a single email message.
     *
     * @param email - Email message to send.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.sendEmail = function (email, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/email", email, callback);
    };
    /**
     * Send a batch of email messages.
     *
     * @param emails - An array of messages to send.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.sendEmailBatch = function (emails, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/email/batch", emails, callback);
    };
    /**
     * Send a message using a template.
     *
     * @param template - Message you wish to send.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.sendEmailWithTemplate = function (template, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/email/withTemplate", template, callback);
    };
    /**
     * Send a batch of template email messages.
     *
     * @param templates - An array of templated messages you wish to send using this Client.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.sendEmailBatchWithTemplates = function (templates, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/email/batchWithTemplates", { Messages: templates }, callback);
    };
    /**
     * Get bounce statistic information for the associated Server.
     *
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getDeliveryStatistics = function (callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/deliveryStats", {}, callback);
    };
    /**
     * Get a batch of bounces.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getBounces = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.BounceFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/bounces", filter, callback);
    };
    /**
     * Get details for a specific Bounce.
     *
     * @param id - The ID of the Bounce you wish to retrieve.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getBounce = function (id, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/bounces/".concat(id), {}, callback);
    };
    /**
     * Get a Bounce Dump for a specific Bounce.
     *
     * @param id - The ID of the Bounce for which you wish to retrieve Bounce Dump.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getBounceDump = function (id, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/bounces/".concat(id, "/dump"), {}, callback);
    };
    /**
     * Activate email address that was deactivated due to a Bounce.
     *
     * @param id - The ID of the Bounce for which you wish to activate the associated email.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.activateBounce = function (id, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.PUT, "/bounces/".concat(id, "/activate"), {}, callback);
    };
    /**
     * Get the list of templates associated with this server.
     *
     * @param filter - Optional filtering options.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getTemplates = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.TemplateFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/templates", filter, callback);
    };
    /**
     * Get the a specific template associated with this server.
     *
     * @param idOrAlias - ID or alias for the template you wish to retrieve.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getTemplate = function (idOrAlias, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/templates/".concat(idOrAlias), {}, callback);
    };
    /**
     * Delete a template associated with this server.
     *
     * @param idOrAlias - ID or template alias you wish to delete.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.deleteTemplate = function (idOrAlias, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.DELETE, "/templates/".concat(idOrAlias), {}, callback);
    };
    /**
     * Create a new template on the associated server.
     *
     * @param options - Configuration options to be used to create the Template.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.createTemplate = function (options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/templates/", options, callback);
    };
    /**
     * Update a template on the associated server.
     *
     * @param idOrAlias - Id or alias of the template you wish to update.
     * @param options - Template options you wish to update.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.editTemplate = function (idOrAlias, options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.PUT, "/templates/".concat(idOrAlias), options, callback);
    };
    /**
     * Validate template markup to verify that it will be parsed. Also provides a recommended template
     * model to be used when sending using the specified template content.
     *
     * @param options - The template content you wish to validate.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.validateTemplate = function (options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/templates/validate", options, callback);
    };
    /**
     * Get the information for the Server associated with this Client.
     *
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getServer = function (callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/server", {}, callback);
    };
    /**
     * Modify the Server associated with this Client.
     *
     * @param options - The options you wish to modify.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.editServer = function (options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.PUT, "/server", options, callback);
    };
    /**
     * Get a batch of Outbound Messages.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getOutboundMessages = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.OutboundMessagesFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/outbound", filter, callback);
    };
    /**
     * Get details for a specific Outbound Message.
     *
     * @param messageId - The ID of the OutboundMessage you wish to retrieve.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getOutboundMessageDetails = function (messageId, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/outbound/".concat(messageId), {}, callback);
    };
    /**
     * Get details for a specific Outbound Message.
     *
     * @param messageId - The ID of the OutboundMessage you wish to retrieve.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getOutboundMessageDump = function (messageId, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/outbound/".concat(messageId, "/dump"), {}, callback);
    };
    /**
     * Get a batch of Inbound Messages.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getInboundMessages = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.InboundMessagesFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/inbound", filter, callback);
    };
    /**
     * Get details for a specific Inbound Message.
     *
     * @param messageId - The ID of the Inbound Message you wish to retrieve.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getInboundMessageDetails = function (messageId, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/inbound/".concat(messageId, "/details"), {}, callback);
    };
    /**
     * Cause an Inbound Message to bypass filtering rules defined on this Client's associated Server.
     *
     * @param messageId - The ID of the Inbound Message for which you wish to bypass the filtering rules.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.bypassBlockedInboundMessage = function (messageId, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.PUT, "/messages/inbound/".concat(messageId, "/bypass"), {}, callback);
    };
    /**
     * Request that Postmark retry POSTing to the Inbound Hook for the specified message.
     *
     * @param messageId - The ID of the Inbound Message for which you wish to retry the inbound hook.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.retryInboundHookForMessage = function (messageId, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.PUT, "/messages/inbound/".concat(messageId, "/retry"), {}, callback);
    };
    /**
     * Get the Opens for Outbound Messages.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getMessageOpens = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.OutboundMessageOpensFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/outbound/opens", filter, callback);
    };
    /**
     * Get details of Opens for specific Outbound Message.
     *
     * @param messageId - Message ID of the message for which you wish to retrieve Opens.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getMessageOpensForSingleMessage = function (messageId, filter, callback) {
        if (filter === void 0) { filter = new index_2.OutboundMessageOpensFilteringParameters(50, 0); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/outbound/opens/".concat(messageId), filter, callback);
    };
    /**
     * Get the Clicks for Outbound Messages.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getMessageClicks = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.OutboundMessageClicksFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/outbound/clicks", filter, callback);
    };
    /**
     * Get Click information for a single Outbound Message.
     *
     * @param messageId - The MessageID for which clicks should be retrieved.
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getMessageClicksForSingleMessage = function (messageId, filter, callback) {
        if (filter === void 0) { filter = new index_2.OutboundMessageClicksFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/messages/outbound/clicks/".concat(messageId), filter, callback);
    };
    /**
     * Get overview statistics on Outbound Messages sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getOutboundOverview = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound", filter, callback);
    };
    /**
     * Get statistics on email sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getSentCounts = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/sends", filter, callback);
    };
    /**
     * Get statistiscs on emails that bounced after being sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getBounceCounts = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/bounces", filter, callback);
    };
    /**
     * Get SPAM complaint statistics for email sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getSpamComplaintsCounts = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/spam", filter, callback);
    };
    /**
     * Get email tracking statistics for messages sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getTrackedEmailCounts = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/tracked", filter, callback);
    };
    /**
     * Get Open statistics for messages sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getEmailOpenCounts = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/opens", filter, callback);
    };
    /**
     * Get Email Client Platform statistics for messages sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getEmailOpenPlatformUsage = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/opens/platforms", filter, callback);
    };
    /**
     * Get statistics on which Email Clients were used to open messages sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getEmailOpenClientUsage = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/opens/emailClients", filter, callback);
    };
    /**
     * Get Read Time statistics for messages sent from the Server associated with this Client.
     * @param filter Optional filtering parameters.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getEmailOpenReadTimes = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/opens/readTimes", filter, callback);
    };
    /**
     * Get total clicks statistics for tracked links for messages sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getClickCounts = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/clicks", filter, callback);
    };
    /**
     * Get browser family statistics for tracked links for messages sent from the Server associated with this Client.
     * @param filter Optional filtering parameters.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getClickBrowserUsage = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/clicks/browserFamilies", filter, callback);
    };
    /**
     * Get browser platform statistics for tracked links for messages sent from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getClickPlatformUsage = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/clicks/platforms", filter, callback);
    };
    /**
     * Get click location (in HTML or Text body of the email) statistics for tracked links for messages sent
     * from the Server associated with this Client.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getClickLocation = function (filter, callback) {
        if (filter === void 0) { filter = new index_2.StatisticsFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/stats/outbound/clicks/location", filter, callback);
    };
    /**
     * Create an Inbound Rule Trigger.
     *
     * @param options - Configuration options to be used when creating this Trigger.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.createInboundRuleTrigger = function (options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/triggers/inboundRules", options, callback);
    };
    /**
     * Delete an Inbound Rule Trigger.
     *
     * @param id - The ID of the Inbound Rule Trigger you wish to delete.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.deleteInboundRuleTrigger = function (id, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.DELETE, "/triggers/inboundRules/".concat(id), {}, callback);
    };
    /**
     * Get a list of Inbound Rule Triggers.
     *
     * @param filter - Optional filtering parameters.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getInboundRuleTriggers = function (filter, callback) {
        if (filter === void 0) { filter = new index_1.FilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/triggers/inboundRules", filter, callback);
    };
    /**
     * Get the list of Webhooks for specific server.
     *
     * @param filter - Optional filtering parameters
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getWebhooks = function (filter, callback) {
        if (filter === void 0) { filter = {}; }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/webhooks", filter, callback);
    };
    /**
     * Get details for a specific Webhook.
     *
     * @param id - The ID of the Webhook you wish to retrieve.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getWebhook = function (id, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/webhooks/".concat(id), {}, callback);
    };
    /**
     * Create a Webhook on the associated server.
     *
     * @param options - Configuration options to be used when creating Webhook trigger.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.createWebhook = function (options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/webhooks", options, callback);
    };
    /**
     * Update Webhook on the associated server.
     *
     * @param id - Id of the webhook you wish to update.
     * @param options - Webhook options you wish to update.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.editWebhook = function (id, options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.PUT, "/webhooks/".concat(id), options, callback);
    };
    /**
     * Delete an existing Webhook.
     *
     * @param id - The ID of the Webhook you wish to delete.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.deleteWebhook = function (id, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.DELETE, "/webhooks/".concat(id), {}, callback);
    };
    /**
     * Get the list of message streams on a server.
     *
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getMessageStreams = function (filter, callback) {
        if (filter === void 0) { filter = {}; }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/message-streams", filter, callback);
    };
    /**
     * Get details for a specific message stream on a server.
     *
     * @param id - The ID of the message stream you wish to retrieve.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getMessageStream = function (id, callback) {
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/message-streams/".concat(id), {}, callback);
    };
    /**
     * Update message stream on the associated server.
     *
     * @param id - Id of the webhook you wish to update.
     * @param options - Webhook options you wish to update.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.editMessageStream = function (id, options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.PATCH, "/message-streams/".concat(id), options, callback);
    };
    /**
     * Create a message stream on the associated server.
     *
     * @param options - Configuration options to be used when creating message stream on the server.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.createMessageStream = function (options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/message-streams", options, callback);
    };
    /**
     * Archive a message stream on the associated server.
     *
     * @param options - Configuration options to be used when creating message stream on the server.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.archiveMessageStream = function (id, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/message-streams/".concat(id, "/archive"), {}, callback);
    };
    /**
     * Unarchive a message stream on the associated server.
     *
     * @param options - Configuration options to be used when creating message stream on the server.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.unarchiveMessageStream = function (id, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/message-streams/".concat(id, "/unarchive"), {}, callback);
    };
    /**
     * Get the list of suppressions for a message stream on a server.
     *
     * @param messageStream - Select message stream
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.getSuppressions = function (messageStream, filter, callback) {
        if (filter === void 0) { filter = new index_2.SuppressionFilteringParameters(); }
        return this.processRequestWithoutBody(index_1.ClientOptions.HttpMethod.GET, "/message-streams/".concat(messageStream, "/suppressions/dump"), filter, callback);
    };
    /**
     * Add email addresses to a suppressions list on a message stream on a server.
     *
     * @param messageStream - Select message stream
     * @param options - Suppressions you wish to add.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.createSuppressions = function (messageStream, options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/message-streams/".concat(messageStream, "/suppressions"), options, callback);
    };
    /**
     * Delete email addresses from a suppressions list on a message stream on a server.
     *
     * @param messageStream - Select message stream
     * @param options - Suppressions you wish to delete.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    ServerClient.prototype.deleteSuppressions = function (messageStream, options, callback) {
        return this.processRequestWithBody(index_1.ClientOptions.HttpMethod.POST, "/message-streams/".concat(messageStream, "/suppressions/delete"), options, callback);
    };
    return ServerClient;
}(BaseClient_1.default));
exports.default = ServerClient;
//# sourceMappingURL=ServerClient.js.map