"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AxiosHttpClient = void 0;
var axios_1 = require("axios");
var models_1 = require("./models");
var index_1 = require("./errors/index");
var AxiosHttpClient = /** @class */ (function (_super) {
    __extends(AxiosHttpClient, _super);
    function AxiosHttpClient(configOptions) {
        var _this = _super.call(this, configOptions) || this;
        _this.errorHandler = new index_1.ErrorHandler();
        return _this;
    }
    /**
     * Create http client instance with default settings.
     *
     * @return {AxiosInstance}
     */
    AxiosHttpClient.prototype.initHttpClient = function (configOptions) {
        this.clientOptions = __assign(__assign({}, models_1.HttpClient.DefaultOptions), configOptions);
        var httpClient = axios_1.default.create({
            baseURL: this.getBaseHttpRequestURL(),
            timeout: this.getRequestTimeoutInMilliseconds(),
            responseType: "json",
            maxContentLength: Infinity,
            maxBodyLength: Infinity,
            validateStatus: function (status) {
                return status >= 200 && status < 300;
            },
        });
        httpClient.interceptors.response.use(function (response) { return (response.data); });
        this.client = httpClient;
    };
    /**
     * Process http request.
     *
     * @param method - Which type of http request will be executed.
     * @param path - API URL endpoint.
     * @param queryParameters - Querystring parameters used for http request.
     * @param body - Data sent with http request.
     */
    AxiosHttpClient.prototype.httpRequest = function (method, path, queryParameters, body, requestHeaders) {
        var _this = this;
        return this.client.request({
            method: method,
            url: path,
            data: body,
            headers: requestHeaders,
            params: queryParameters,
        }).catch(function (errorThrown) {
            return Promise.reject(_this.transformError(errorThrown));
        });
    };
    /**
     * Process callback function for HTTP request.
     *
     * @param error - request error that needs to be transformed to proper Postmark error.
     *
     * @return {PostmarkError} - formatted Postmark error
     */
    AxiosHttpClient.prototype.transformError = function (errorThrown) {
        var response = errorThrown.response;
        if (response !== undefined) {
            var status_1 = this.adjustValue(0, response.status);
            var errorCode = this.adjustValue(0, response.data.ErrorCode);
            var message = this.adjustValue(errorThrown.message, response.data.Message);
            return this.errorHandler.buildError(message, errorCode, status_1);
        }
        else if (errorThrown.message !== undefined) {
            return this.errorHandler.buildError(errorThrown.message);
        }
        else {
            return this.errorHandler.buildError(JSON.stringify(errorThrown, Object.getOwnPropertyNames(errorThrown)));
        }
    };
    /**
     * Timeout in seconds is adjusted to Axios format.
     *
     * @private
     */
    AxiosHttpClient.prototype.getRequestTimeoutInMilliseconds = function () {
        return (this.clientOptions.timeout || 60) * 1000;
    };
    AxiosHttpClient.prototype.adjustValue = function (defaultValue, data) {
        return (data === undefined) ? defaultValue : data;
    };
    return AxiosHttpClient;
}(models_1.HttpClient));
exports.AxiosHttpClient = AxiosHttpClient;
//# sourceMappingURL=HttpClient.js.map