import { AxiosInstance } from "axios";
import { ClientOptions, HttpClient } from "./models";
export declare class AxiosHttpClient extends HttpClient {
    client: AxiosInstance;
    private errorHandler;
    constructor(configOptions?: ClientOptions.Configuration);
    /**
     * Create http client instance with default settings.
     *
     * @return {AxiosInstance}
     */
    initHttpClient(configOptions?: ClientOptions.Configuration): void;
    /**
     * Process http request.
     *
     * @param method - Which type of http request will be executed.
     * @param path - API URL endpoint.
     * @param queryParameters - Querystring parameters used for http request.
     * @param body - Data sent with http request.
     */
    httpRequest<T>(method: ClientOptions.HttpMethod, path: string, queryParameters: object, body: (null | object), requestHeaders: any): Promise<T>;
    /**
     * Process callback function for HTTP request.
     *
     * @param error - request error that needs to be transformed to proper Postmark error.
     *
     * @return {PostmarkError} - formatted Postmark error
     */
    private transformError;
    /**
     * Timeout in seconds is adjusted to Axios format.
     *
     * @private
     */
    private getRequestTimeoutInMilliseconds;
    private adjustValue;
}
