"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var BaseClient_1 = require("./BaseClient");
var models_1 = require("./models");
var models_2 = require("./models");
var AccountClient = /** @class */ (function (_super) {
    __extends(AccountClient, _super);
    /**
     * Create a new AccountClient
     * @param accountToken The account token that should be used with requests.
     * @param configOptions Various options to customize client behavior.
     */
    function AccountClient(accountToken, configOptions) {
        return _super.call(this, accountToken, models_1.ClientOptions.AuthHeaderNames.ACCOUNT_TOKEN, configOptions) || this;
    }
    /**
     * Retrieve a list of Servers.
     *
     * @param filter - An optional filter for which data is retrieved.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.getServers = function (filter, callback) {
        if (filter === void 0) { filter = new models_2.ServerFilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.GET, "/servers", filter, callback);
    };
    /**
     * Retrieve a single server by ID.
     *
     * @param id - The ID of the Server for which you wish to retrieve details.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.getServer = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.GET, "/servers/".concat(id), {}, callback);
    };
    /**
     * Create a new Server.
     *
     * @param options - The options to be used to create new Server.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.createServer = function (options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.POST, "/servers", options, callback);
    };
    /**
     * Modify the Server associated with this Client.
     *
     * @param id - The ID of the Server you wish to update.
     * @param options - The options to be used to create new Server.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.editServer = function (id, options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.PUT, "/servers/".concat(id), options, callback);
    };
    /**
     * Modify the Server associated with this Client.
     *
     * @param id - The ID of the Domain you wish to delete.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.deleteServer = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.DELETE, "/servers/".concat(id), {}, callback);
    };
    /**
     * Retrieve a batch of Domains.
     *
     * @param filter - An optional filter for which data is retrieved.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.getDomains = function (filter, callback) {
        if (filter === void 0) { filter = new models_1.FilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.GET, "/domains", filter, callback);
    };
    /**
     * Retrieve a single Domain by ID.
     *
     * @param id - The ID of the Domain for which you wish to retrieve details.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.getDomain = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.GET, "/domains/".concat(id), {}, callback);
    };
    /**
     * Create a new Domain.
     *
     * @param options - The options to be used to create new Domain.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.createDomain = function (options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.POST, "/domains/", options, callback);
    };
    /**
     * Update a Domain.
     *
     * @param id - The ID of the Domain you wish to update.
     * @param domain - The values on the Domain you wish to update.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.editDomain = function (id, options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.PUT, "/domains/".concat(id), options, callback);
    };
    /**
     * Delete a Domain.
     *
     * @param id - The ID of the Domain you wish to delete.
     * @param options - The options to be used in create Domain.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.deleteDomain = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.DELETE, "/domains/".concat(id), {}, callback);
    };
    /**
     * Trigger Domain DKIM key verification.
     *
     * @param id - The ID of the Domain you wish to trigger DKIM verification for.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.verifyDomainDKIM = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.PUT, "/domains/".concat(id, "/verifyDKIM"), {}, callback);
    };
    /**
     * Trigger Domain DKIM key verification.
     *
     * @param id - The ID of the Domain you wish to trigger DKIM verification for.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.verifyDomainReturnPath = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.PUT, "/domains/".concat(id, "/verifyReturnPath"), {}, callback);
    };
    /**
     * Trigger Domain DKIM key verification.
     *
     * @param id - The ID of the Domain you wish to trigger DKIM verification for.
     * @param callback If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.verifyDomainSPF = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.POST, "/domains/".concat(id, "/verifySPF"), {}, callback);
    };
    /**
     * Trigger Domain DKIM key verification.
     *
     * @param id - The ID of the Domain you wish to trigger DKIM verification for.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.rotateDomainDKIM = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.POST, "/domains/".concat(id, "/rotateDKIM"), {}, callback);
    };
    /**
     * Retrieve a single Sender Signature by ID.
     *
     * @param id - The ID of the Sender Signature for which you wish to retrieve details.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.getSenderSignature = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.GET, "/senders/".concat(id), {}, callback);
    };
    /**
     * Retrieve a batch of Sender Signatures.
     *
     * @param filter - An optional filter for which data is retrieved.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.getSenderSignatures = function (filter, callback) {
        if (filter === void 0) { filter = new models_1.FilteringParameters(); }
        this.setDefaultPaginationValues(filter);
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.GET, "/senders", filter, callback);
    };
    /**
     * Create a new Sender Signature.
     *
     * @param options - The options to be used to create new Sender Signature.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.createSenderSignature = function (options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.POST, "/senders/", options, callback);
    };
    /**
     * Update a Sender Signature.
     *
     * @param id - The ID of the Sender Signature for which you wish to update.
     * @param options - The values on the Sender Signature you wish to update.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.editSenderSignature = function (id, options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.PUT, "/senders/".concat(id), options, callback);
    };
    /**
     * Delete a Domain.
     *
     * @param id - The ID of the Domain you wish to delete.
     * @param options - The options to be used in create Domain.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.deleteSenderSignature = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.DELETE, "/senders/".concat(id), {}, callback);
    };
    /**
     * Request a new confirmation email to be sent to the email address associated with a Sender Signature.
     *
     * @param id - The ID of the Sender Signature.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.resendSenderSignatureConfirmation = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.POST, "/senders/".concat(id, "/resend"), {}, callback);
    };
    /**
     * Request that the SPF records for Sender Signature be verified.
     *
     * @param id - The ID of the Sender Signature.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.verifySenderSignatureSPF = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.POST, "/senders/".concat(id, "/verifySpf"), {}, callback);
    };
    /**
     * Request that the SPF records for Sender Signature be verified.
     *
     * @param id - The ID of the Sender Signature.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.requestNewDKIMForSenderSignature = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.POST, "/senders/".concat(id, "/requestNewDkim"), {}, callback);
    };
    /**
     * Request a push of templates from one server to another.
     *
     * @param options - details for pushing templates from one place to another.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.pushTemplates = function (options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.PUT, "/templates/push", options, callback);
    };
    /**
     * Request a data removal.
     *
     * @param options - details for creating data removal request
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.requestDataRemoval = function (options, callback) {
        return this.processRequestWithBody(models_1.ClientOptions.HttpMethod.POST, "/data-removals", options, callback);
    };
    /**
     * Retrieve a single data removal status by ID.
     *
     * @param id - The ID of the DataRemoval for which you wish to retrieve details.
     * @param callback - If the callback is provided, it will be passed to the resulting promise as a continuation.
     * @returns A promise that will complete when the API responds (or an error occurs).
     */
    AccountClient.prototype.getDataRemovalStatus = function (id, callback) {
        return this.processRequestWithoutBody(models_1.ClientOptions.HttpMethod.GET, "/data-removals/".concat(id), {}, callback);
    };
    return AccountClient;
}(BaseClient_1.default));
exports.default = AccountClient;
//# sourceMappingURL=AccountClient.js.map