
const db = require('../../database');


class produitModel {
//get all produit

    static async getProduit() {

        const sql = "SELECT * FROM produit";
        return await db.executeQuery(sql)
    }
    static async getReference(reference){
        const sql = "SELECT * FROM produit WHERE reference = ?";
        return await db.executeQuery(sql, [reference]);
}
    static async getProduitVedette(){
        const sql = `
        SELECT p.designation, p.prix_unitaire_HT, p.reference, p.imageUrl,p.commentaire, 
               SUM(lc.quantite_demandee) AS total_commande 
        FROM ligne_commande AS lc 
        INNER JOIN produit AS p ON lc.reference = p.reference
        GROUP BY p.reference, p.designation, p.prix_unitaire_HT, p.imageUrl 
        ORDER BY total_commande DESC 
        LIMIT 4
    `;

        return await db.executeQuery(sql);
    }
    static async getProduitPromotion(){
        const sql = `
            SELECT p.designation, p.prix_unitaire_HT AS prix_initiale,  p.reference, p.imageUrl,p.commentaire, 
              SUM(p.prix_unitaire_HT*0.70) AS nouveau_prix, 
              SUM(lc.quantite_demandee) AS total_commande 
            FROM ligne_commande AS lc 
            INNER JOIN produit AS p ON lc.reference = p.reference
            GROUP BY p.reference, p.designation, p.prix_unitaire_HT, p.imageUrl 
            ORDER BY total_commande ASC LIMIT 4 `;

        return await db.executeQuery(sql);
    }



}

module.exports = produitModel