const produitModel = require('../model/produitModel');

const produitController = {

    getProduit: async (req,res) => {
        try{
            const produit = await produitModel.getProduit();
            res
                .status(200)
                .json(produit)
        }
        catch(error){
            res
                .status(500)
                .send("Erreur lors de la récupération des produits " + error.message);
        }
    },
    getReference: async (req,res) => {
        try{
            const reference = await produitModel.getReference(req.params.reference);
            res
                .status(200)
                .json(reference)
        }
        catch(error){
            res
                .status(500)
                .send("Erreur lors de la récupération des references " + error.message);
        }
    },

    getProduitVedette: async (req,res) => {
        try{
            const produitVedette = await produitModel.getProduitVedette();
            res
                .status(200)
                .json(produitVedette)
        }
        catch(error){
            res
                .status(500)
                .send("Erreur lors de la récupération des produits " + error.message);
        }
    },

    getProduitPromotion: async (req,res) => {
        try{
            const produitPromotion = await produitModel.getProduitPromotion();
            res
                .status(200)
                .json(produitPromotion)
        }
        catch(error){
            res
                .status(500)
                .send("Erreur lors de la récupération des produits " + error.message);
        }
    }

}

module.exports = produitController