const express = require('express');
const clientController = require("../controller/clientController");
const router = express.Router();
const auth = require('../../middleware/authMiddleware');
const {getTopArticle} = require("../model/clientModel"); // (Adaptez le chemin)


//Create client

router.post("/client/register", clientController.createClient);

router.post("/client/profil/:codec", clientController.createClient);

router.post("/client/login", clientController.login);

//Afficher les données client


router.get("/profil",auth, clientController.profilClient);

// statistiques total dépensé

router.get("/profil/depense",auth, clientController.getProfilDepense);

//Stats article préféré

router.get("/profil/topArticle", auth, clientController.getTopArticle);

//dernière commande

router.get("/profil/derniereCommande", auth, clientController.getDerniereCommande);

//Historique des commandes

router.get("/profil/historique", auth, clientController.getHistorique);

// nombre commande

router.get("/profil/nombreCommande", auth, clientController.getNombreCommande);


module.exports = router;




