const db = require("../../database");
const bcrypt = require("bcrypt");

class clientModel  {

    static async profilClient(codec) {
        const sql = "SELECT * FROM client WHERE codec = ?";

        const result = await db.executeQuery(sql, [codec]);
        return result[0];
    }
    static async checkExistingClient (params) {
        const mail = params.mail;
        const sql = "SELECT * FROM client WHERE mail = ?";
        return await db.executeQuery(sql, mail);

    }
    static async createClient(params)  {
        const { nom, cp, ville, mail, password } = params;


    //Vérifier si l'email existe déjà
        const sql = "SELECT * FROM client WHERE mail = ?";
        const result = await db.executeQuery(sql, mail);

        if (result.length > 0) {
            return;
        }

    // hash du mot de passe avant inertion

        const hashedPassword = await bcrypt.hash(password, 10);


    // Insérer le nouveau client en bdd
        const insertsql = "INSERT INTO client (nom, cp, ville, mail, password) VALUES (?,?,?,?,?)";
        return await db.executeQuery(insertsql, [nom, cp, ville, mail, hashedPassword]);
    }

    //compare pass word
    static async comparePassword (password, hash) {
        return await bcrypt.compare(password, hash);
    }

    static async getProfilDepense(codec){
        const sql = " SELECT SUM(total_ht + total_tva) AS total FROM commande WHERE codec = ?";

        return await db.executeQuery(sql, [codec]);
    }

    static async getTopArticle(codec){
        const sql = "SELECT designation FROM commande JOIN ligne_commande ON commande.numero = ligne_commande.numero JOIN produit  ON ligne_commande.reference = produit.reference WHERE codec = ? GROUP BY produit.reference, produit.designation ORDER BY SUM(ligne_commande.quantite_demandee) DESC LIMIT 1"

        return await db.executeQuery(sql,[codec]);
    }
    static async getDerniereCommande(codec){

        const sql = "SELECT c.Nom, p.designation, cmd.date_commande, p.imageUrl, lc.quantite_demandee, (lc.quantite_demandee * p.prix_unitaire_HT) AS total_ligne_HT, (cmd.total_HT + cmd.total_TVA) AS total_commande_TTC,Round( ((cmd.total_HT + cmd.total_TVA) - SUM(lc.quantite_demandee * p.prix_unitaire_HT) OVER()),2) AS tva FROM client c INNER JOIN commande cmd ON c.codec = cmd.codec INNER JOIN ligne_commande lc ON cmd.numero = lc.numero INNER JOIN produit p ON lc.reference = p.reference WHERE cmd.numero = (SELECT numero FROM commande WHERE codec = ? ORDER BY date_commande DESC, numero DESC LIMIT 1)";

        return await db.executeQuery(sql,[codec]);
    }
    static async getNombreCommande(codec){
        const sql = "SELECT COUNT(date_commande) AS date FROM commande WHERE codec = ? "

        return await db.executeQuery(sql,[codec]);
    }

    static async getHistorique(codec) {
        const sql = "SELECT cmd.numero AS numero_commande, c.Nom, p.designation, cmd.date_commande, p.imageUrl, lc.quantite_demandee, (lc.quantite_demandee * p.prix_unitaire_HT) AS total_ligne_HT, (cmd.total_HT + cmd.total_TVA) AS total_commande_TTC, cmd.total_TVA AS tva FROM client c INNER JOIN commande cmd ON c.codec = cmd.codec INNER JOIN ligne_commande lc ON cmd.numero = lc.numero INNER JOIN produit p ON lc.reference = p.reference WHERE c.codec = ? ORDER BY cmd.date_commande ASC, cmd.numero ASC";

        return await db.executeQuery(sql, [codec]);
    }


}

module.exports = clientModel;