const clientModel = require('../model/clientModel');
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const produitModel = require("../../mod_produit/model/produitModel");
class clientController  {

    static async createClient(req,res)  {
        try{
       // const{nom, cp, ville, mail, password} = req.body;
             const check = await clientModel.checkExistingClient(req.body);
            if (check.length > 0){
                res
                .status(500)
                    .json({message:"Client already exists"})
                return;
            }


        const client = await clientModel.createClient(req.body);
        res
            .status(201)
            .send("votre compte à été créé avec succès");
    }
    catch(error){
      res
            .status(500)
          .send("erreur lors de la création du compte " + error.message);
    }
    }
    static async profilClient(req, res) {
        try {
            // 1. Le middleware 'auth' a vérifié le token et ajouté les infos dans req.auth
            // On récupère le 'codec' qui a été mis dans le token au moment du login.
            const clientCodec = req.auth.codec;

            // Sécurité : on vérifie qu'on a bien un codec
            if (!clientCodec) {
                return res.status(401).json({ message: "Token invalide." });
            }

            // 2. On appelle le modèle pour récupérer le profil avec le bon codec
            // Je renomme la variable pour plus de clarté
            const profil = await clientModel.profilClient(clientCodec); // Assure-toi que la fonction existe dans ton modèle

            // 3. On vérifie si un profil a été trouvé
            if (!profil) {
                return res.status(404).json({ message: "Profil non trouvé." });
            }

            res.status(200).json(profil);

        } catch (error) {
            // BIEN: res.json() envoie un objet JSON
            res.status(500).json({ message: "Erreur lors de la récupération du profil : " + error.message });
        }
    }
    // Login
    static async login(req,res)  {
        try{
            const {mail, password} = req.body;

            const client = await clientModel.checkExistingClient(req.body);
            if (client.length === 0){
                res
                .status(401)
                .json({message:"l'identifiant est incorrecte"})

                return;
            }

            const valideClient =client[0];


            console.log(valideClient.password);
            //vérification du mot de passe

            const isMatch = await clientModel.comparePassword(password,valideClient.password);

            if (!isMatch){
                return(
                res
                    .status(401)
                    .json({message:"le mot de passe est incorrecte"}))

            }
            //génération d'un toker JWT
            const token = jwt.sign(
                { codec: valideClient.codec, nom: valideClient.nom ,ville: valideClient.ville },
                process.env.JWT_SECRET,
                {expiresIn: process.env.JWT_EXPIRES_IN}
            );
            res.json({
                message:"login success",
                token,
            });

        }catch(error){
            console.error("Erreur lors de la conexion", error);
            res.status(500).json({message: "Erreur serveur"});
        }
    }
    static async getProfilDepense(req, res) {
        try {
            const clientCodec = req.auth.codec;
            if (!clientCodec) {
                return res.status(401).json({ message: "Token invalide." });
            }

            // 2. ON APPELLE LE BON MODÈLE

            const depense = await clientModel.getProfilDepense(clientCodec);

            // 3. On vérifie le résultat
            if (!depense) {
                return res.status(200).json({ total: 0 });
            }
            // 4. On renvoie le JSON

            res.status(200).json(depense);

        } catch (error) {
            res.status(500).json({ message: "Erreur lors de la récupération des dépenses : " + error.message });
        }
    }
    static async getTopArticle(req, res) {
        try {
            const clientCodec = req.auth.codec;
            if (!clientCodec) {
                return res.status(401).json({ message: "Token invalide." });
            }

            const article = await clientModel.getTopArticle(clientCodec);

            // 3. On vérifie le résultat
            if (!article) {
                return res.status(200).json({ total: 0 });
            }
            // 4. On renvoie le JSON

            res.status(200).json(article);

        } catch (error) {
            res.status(500).json({ message: "Erreur lors de la récupération de l'artcile préféré : " + error.message });
        }
    }

    static async getDerniereCommande(req, res) {
        try {
            const clientCodec = req.auth.codec;
            if (!clientCodec) {
                return res.status(401).json({ message: "Token invalide." });
            }

            const derniereCommande = await clientModel.getDerniereCommande(clientCodec);

            // 3. On vérifie le résultat
            if (!derniereCommande) {
                return res.status(200).json({ total: 0 });
            }
            // 4. On renvoie le JSON

            res.status(200).json(derniereCommande);

        } catch (error) {
            res.status(500).json({ message: "Erreur lors de la récupération de la dernière commande : " + error.message });
        }
    }
    static async getNombreCommande(req, res) {
        try {
            const clientCodec = req.auth.codec;
            if (!clientCodec) {
                return res.status(401).json({ message: "Token invalide." });
            }

            const nombreCommande = await clientModel.getNombreCommande(clientCodec);

            // 3. On vérifie le résultat
            if (!nombreCommande) {
                return res.status(200).json({ total: 0 });
            }
            // 4. On renvoie le JSON

            res.status(200).json(nombreCommande);

        } catch (error) {
            res.status(500).json({ message: "Erreur lors de la récupération de la dernière commande : " + error.message });
        }
    }

    static async getHistorique(req, res) {
        try {
            const clientCodec = req.auth.codec;
            if (!clientCodec) {
                return res.status(401).json({ message: "Token invalide." });
            }

            const HistoriqueCommande = await clientModel.getHistorique(clientCodec);

            // 3. On vérifie le résultat
            if (!HistoriqueCommande) {
                return res.status(200).json({ total: 0 });
            }
            // 4. On renvoie le JSON

            res.status(200).json(HistoriqueCommande);

        } catch (error) {
            res.status(500).json({ message: "Erreur lors de la récupération des dernières commandes : " + error.message });
        }
    }

}
module.exports = clientController;