const jwt = require('jsonwebtoken');
require('dotenv').config(); // S'assure que process.env.JWT_SECRET est lu

const auth = (req, res, next) => {

    // Le 'try catch' empêche l'API de crasher
    try {
        // 1. On récupère le token
        const authHeader = req.headers.authorization;

        // 2. On vérifie si le token existe et est bien formaté
        if (!authHeader || !authHeader.startsWith('Bearer ')) {
            // Si le token est manquant, on renvoie une erreur JSON propre.
            return res.status(401).json({ message: "Authentification échouée : token manquant ou invalide." });
        }

        // 3. On isole le token
        const token = authHeader.split(' ')[1];

        // 4. On vérifie le token.
        // Si le token est faux ou expiré, cela va générer une erreur
        // et l'exécution sautera directement au bloc 'catch'.
        const decodedToken = jwt.verify(token, process.env.JWT_SECRET);


        // Si on arrive ici, le token est valide.
        // On crée l'objet 'req.auth' pour le contrôleur.
        // le login signe avec 'codec', donc on le met ici.
        req.auth = {
            codec: decodedToken.codec
        };

        // 6. On passe au contrôleur (clientController.profilClient)
        next();

    } catch (error) {
        // 7. Si le 'try' a échoué (token expiré, faux secret, etc.)
        // On renvoie une erreur JSON propre au lieu de crasher l'API.
        res.status(401).json({ message: "Authentification échouée : " + error.message });
    }
};

module.exports = auth;