const express = require("express");
const cors = require("cors");
const produitRoutes = require("./mod_produit/route/produitRouter");
const clienteRoutes = require("./mod_client/route/clientRouter");
const {join} = require("node:path");


require("dotenv").config(); //permet de charger des variables d'environnement

const app = express();
app.use(express.json());

// paramètre de CORS (Cross-origin)
//paramrtre d'accès pour accèder à l'API

app.use(cors({
    origin: '*',
    methods: ['GET', 'POST', 'PUT', 'DELETE'],
    allowedHeaders: ['Authorization', 'Content-Type'],
    credentials: true
    }
))

// premoière route

app.use(produitRoutes);
app.use(clienteRoutes);
//app.use('/images', express.static('images'));
app.use('/images', express.static(join(__dirname, 'public/images')));
app.listen(process.env.PORT, process.env.HOST, function () {
    console.log(`Serveur lancé sur http://${process.env.HOSTNAME}:${process.env.PORT}\n`);
})