const mysql = require("mysql2/promise");
require("dotenv").config();

const pool = mysql.createPool({
    host: process.env.DB_HOST,
    port: process.env.DB_PORT,
    user: process.env.DB_USER,
    password: process.env.DB_PASS,
    database: process.env.MYSQL_DB,
    waitForConnections: true,
    connectionLimit: parseInt(process.env.MYSQL_CONNECTION_LIMIT, 10),
    queueLimit: 0,
})


async function executeQuery(sql, params = []) {
    try {
        const[results] = await pool.query(sql, params);
        return results;
    }catch(error) {
        throw error;
    }
}

module.exports = {
    executeQuery
}