<!doctype html>
<!--[if lt IE 7]>
<html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>
<html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>
<html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{$titreVue}</title>
    <meta name="description" content="{$titreVue}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="apple-icon.png">
    <link rel="shortcut icon" href="public/favicon.ico">

    <link rel="stylesheet" href="public/assets/css/normalize.css">
    <link rel="stylesheet" href="public/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="public/assets/css/themify-icons.css">
    <link rel="stylesheet" href="public/assets/css/flag-icon.min.css">
    <link rel="stylesheet" href="public/assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="public/assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/scss/style.css">
    <link href="public/assets/css/lib/vector-map/jqvmap.min.css" rel="stylesheet">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>
</head>
<body>

<!-- Left Panel -->
{include file='public/left.tpl'}
<!-- FIN : Left Panel -->

<!-- Right Panel -->
<div id="right-panel" class="right-panel">

    <!--Header -->
    {include file='public/header.tpl'}
    <!-- FIN : header -->

    <div class="breadcrumbs">
        <div class="col-sm-4">
            <div class="page-header float-left">
                <div class="page-title">
                    <h1>La gourmandise, ça se partage !</h1>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="page-header float-right">
                <div class="page-title">
                    <ol class="breadcrumb text-right">
                        <li><a href="index.php">Accueil</a></li>
                        <li><a href="index.php?gestion=profil">Profils</a></li>
                        <li class="active">{$titreVue}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div {if $messageErreur neq ''}class="alert alert-danger" role="alert"{/if}>
        {$messageErreur}
    </div>

    <div class="content mt-3">
        <div class="animated fadeIn">
            <div class="row">
                <!-- Bloc 1 : Profil -->
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header"><strong>{$titrePage}</strong></div>
                        <form action="index.php" method="POST" novalidate>
                            <input type="hidden" name="gestion" value="vendeur">
                            <input type="hidden" name="action" value="{$action}">
                            <div class="card-body card-block">
                                {if $action neq 'ajouter'}
                                    <div class="form-group">
                                        <label for="codev" class="form-control-label">Code Vendeur :</label>
                                        <input type="number" name="codev" class="form-control" readonly value="{$unProfil->getCodev()}">
                                    </div>
                                {/if}
                                <div class="form-group">
                                    <label for="nom" class="form-control-label">Nom <sup>(*)</sup> :</label>
                                    <input type="text" name="nom" class="form-control" value="{$unProfil->getNom()}" {$readonly} required>
                                </div>
                                <div class="form-group">
                                    <label for="adresse" class="form-control-label">Adresse :</label>
                                    <input type="text" name="adresse" class="form-control" value="{$unProfil->getAdresse()}" {$readonly} required>
                                </div>
                                <div class="form-group">
                                    <label for="cp" class="form-control-label">Code Postal<sup>(*)</sup> :</label>
                                    <input type="text" name="cp" class="form-control" value="{$unProfil->getCp()}" {$readonly} required>
                                </div>
                                <div class="form-group">
                                    <label for="ville" class="form-control-label">Ville<sup>(*)</sup> :</label>
                                    <input type="text" name="ville" class="form-control" value="{$unProfil->getVille()}" {$readonly}>
                                </div>
                                <div class="form-group">
                                    <label for="telephone" class="form-control-label">Téléphone :</label>
                                    <input type="text" name="telephone" class="form-control" value="{$unProfil->getTelephone()}" {$readonly}>
                                </div>
                                <div class="form-group">
                                    <label for="login" class="form-control-label">Identifiant :</label>
                                    <input type="text" name="login" class="form-control" value="{$unProfil->getLogin()}" {$readonly}>
                                </div>
                            </div>
                            <div class="card-body card-block">
                                <div class="col-md-6">
                                    <input type="button" class="btn btn-submit" value="Retour" onclick='location.href = "index.php"'>
                                </div>

                                <br>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Bloc 2 : Changer mot de passe -->
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header"><strong>Changer de mot de passe</strong></div>
                        <div class="card-body card-block">
                            {if $messageSucces neq ''}
                                <div class="alert alert-success">{$messageSucces}</div>
                            {/if}

                            {if $messageErreur neq ''}
                                <div class="alert alert-danger">{$messageErreur}</div>
                            {/if}
                            <form method="post" action="index.php">
                                <input type="hidden" name="gestion" value="profil">
                                <input type="hidden" name="action" value="changerMotDePasse">
                                <div class="form-group">
                                    <label for="motDePasse" class="form-control-label">Mot de passe actuelle</label>
                                    <input type="password" id="motDePasse" name="motDePasse" placeholder="Mot de passe actuelle" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label for="nouveauMotDePasse" class="form-control-label">Nouveau mot de passe</label>
                                    <input type="password" id="nouveauMotDePasse" name="nouveauMotDePasse" placeholder="Nouveau mot de passe" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label for="confirmNouveauMotDePasse" class="form-control-label">Confirmer le nouveau mot de passe</label>
                                    <input type="password" id="confirmNouveauMotDePasse" name="confirmNouveauMotDePasse" placeholder="Confirmer le mot de passe" class="form-control"required>
                                </div>
                                <button type="submit" class="btn btn-primary">Valider</button>
                            </form>
                        </div>
                    </div>

                    <div class="col-md-12 ml-auto">
                        <div class="card">
                            <div class="card-header"><strong>Statistiques</strong></div>
                            <div class="card-body card-block">

                                <div class="form-group"><strong>CA Réalisé : {$unProfil->getTotalCa()} €</strong></div>
                                <div class="form-group"><strong>Pourcentage du chiffres d'affaires réalisé :  {$unProfil->getPourcentageVendeur()} %</strong></div>
                                <div class="form-group"><strong>Article le plus Vendu : {$unProfil->getArticle()}🏆</strong></div>

                            </div>
                        </div>
                    </div>

                </div>



            </div>


            </div> <!-- .row -->
        </div> <!-- .animated -->
    </div> <!-- .content -->

</div> <!-- /#right-panel -->

<!-- Scripts -->
<script src="public/assets/js/vendor/jquery-2.1.4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"></script>
<script src="public/assets/js/plugins.js"></script>
<script src="public/assets/js/main.js"></script>
<script src="public/assets/js/lib/data-table/datatables.min.js"></script>
<script src="public/assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
<script src="public/assets/js/lib/data-table/dataTables.buttons.min.js"></script>
<script src="public/assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
<script src="public/assets/js/lib/data-table/jszip.min.js"></script>
<script src="public/assets/js/lib/data-table/pdfmake.min.js"></script>
<script src="public/assets/js/lib/data-table/vfs_fonts.js"></script>
<script src="public/assets/js/lib/data-table/buttons.html5.min.js"></script>
<script src="public/assets/js/lib/data-table/buttons.print.min.js"></script>
<script src="public/assets/js/lib/data-table/buttons.colVis.min.js"></script>
<script src="public/assets/js/lib/data-table/datatables-init.js"></script>

<script type="text/javascript">
    $(document).ready(function () {
        $('#bootstrap-data-table-export').DataTable();
    });
</script>

</body>
</html>
