<?php


class ProfilModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeProfils()
    {

        $sql = 'SELECT * FROM vendeur';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($profil = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeProfils[] = new ProduitTable($profil);

            }

            return $listeProfils;

        } else {

            return null;
        }
    }
    public function getUnProfil() {
        if (!isset($_SESSION["codevendeur"])) {
            throw new Exception("Aucun vendeur connecté.");
        }

        $sql = 'SELECT * FROM vendeur WHERE codev = ?';
        $idRequete = $this->executeRequete($sql, [$_SESSION["codevendeur"]]);
        return new ProfilTable($idRequete->fetch(PDO::FETCH_ASSOC));
    }
    public function addProfil(ProfilTable $profil)
    {
        $sql = 'INSERT INTO vendeur(nom,prenom,adresse,cp,ville,telephone,login,motdepasse)VALUES(?,?,?,?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $profil->getNom(),
            $profil->getPrenom(),
            $profil->getAdresse(),
            $profil->getCp(),
            $profil->getVille(),
            $profil->getTelephone(),
            $profil->getLogin(),
            $profil->getMotdepasse(),
            password_hash($profil->getMotdepasse(), PASSWORD_DEFAULT),
        ]);
        if($idRequete){
            ProfilTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editProfil(ProfilTable $profil)
    {
        $sql = 'UPDATE vendeur SET nom = ?,SET prenom = ? adresse = ?, cp = ?, ville = ?, telephone = ?,login = ?,motdepasse = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $profil->getNom(),
            $profil->getPrenom(),
            $profil->getAdresse(),
            $profil->getCp(),
            $profil->getVille(),
            $profil->getTelephone(),
            $profil->getLogin(),
            $profil->getMotdepasse(),
        ]);
        if($idRequete){
            ProduitTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM prenom WHERE codev = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codev']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        }else{
            return true;
        }
    }
    public function deleteProfil(){
        $sql = 'DELETE FROM profil WHERE codev = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codev']]);

        if ($idRequete) {

            ProfilTable::setMessageSucces("suppression avec succes");
        }
    }
    public function mettreAJourMotDePasse($motDePasse, $nouveauMotDePasse) {
        if (!isset($_SESSION['codevendeur'])) return false;

        $codev = $_SESSION['codevendeur'];

        $sql = "SELECT motdepasse FROM vendeur WHERE codev = ?";
        $result = $this->executeRequete($sql, [$codev]);

        if ($result && $donnees = $result->fetch(PDO::FETCH_ASSOC)) { //pdo = php data object

           //meme salage et hash que dans setMotdepasse()
            $gauche = "ar30&y%";
            $droite = "tk!@";
            $motDePasseSaisiHashe = hash('ripemd128', "$gauche$motDePasse$droite");

            // Comparer les deux hash
            if ($motDePasseSaisiHashe === $donnees['motdepasse']) {
                // Hash du nouveau mot de passe
                $nouveauMotDePasseHashe = hash('ripemd128', "$gauche$nouveauMotDePasse$droite");

                $sql = "UPDATE vendeur SET motdepasse = ? WHERE codev = ?";
                $this->executeRequete($sql, [$nouveauMotDePasseHashe, $codev]);

                return true;
            }
        }

        return false;
    }

    public function totalVente(ProfilTable $profil){

        $sql = 'SELECT SUM(total_ht + total_tva) AS total
                FROM commande
                WHERE codev = ?;';

        $idRequete = $this->executeRequete($sql, [$_SESSION["codevendeur"]]);

        $row = $idRequete->fetch(PDO::FETCH_ASSOC);

        if ($row && $row["total"] !== null) {
            $profil->setTotalCa($row['total']);
        } else {
            $profil->setTotalCa("0");
        }

    }

    public function CaVendeur(ProfilTable $profil){

        $sql = 'SELECT ROUND(SUM(total_ht + total_tva) * 100.0 /
                (SELECT SUM(total_ht + total_tva) FROM commande) ,2) AS pourcentage_client
                FROM commande
                WHERE codev = ?;';

        $idRequete = $this->executeRequete($sql, [$_SESSION["codevendeur"]]);

        $row = $idRequete->fetch(PDO::FETCH_ASSOC);

        if ($row && $row["pourcentage_client"] !== null) {
            $profil->setPourcentageVendeur($row['pourcentage_client']);
        } else {
            $profil->setPourcentageVendeur("0");
        }

    }


    public function article01(ProfilTable $profil)
    {

        $sql = 'SELECT designation
                FROM commande 
                JOIN ligne_commande ON commande.numero = ligne_commande.numero
                JOIN produit  ON ligne_commande.reference = produit.reference
                WHERE codev = ?
                GROUP BY produit.reference, produit.designation
                ORDER BY SUM(ligne_commande.quantite_demandee) DESC
                LIMIT 1;';

        $idRequete = $this->executeRequete($sql,[$_SESSION["codevendeur"]]);

        if ($idRequete) {
            $row = $idRequete->fetch(PDO::FETCH_ASSOC);

            if ($row && $row["designation"] !== null) {
                $profil->setArticle($row['designation']);
            } else {
                $profil->setArticle("--");
            }

        } else {
            // Facultatif : log pour aider au debug
            error_log("La requête SQL dans article() a échoué.");
            $profil->setArticle(0);
        }

    }

}
