<?php
require __DIR__ . '/../../vendor/autoload.php';
use Dompdf\Dompdf;
use Dompdf\Options;

try {
    $pdo = new PDO(
        'mysql:host=localhost;dbname=seraphinparys;charset=utf8mb4',
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
} catch (Throwable $e) {
    http_response_code(500);
    exit('Connexion BD impossible: '.$e->getMessage());
}

// ---- Récup ref depuis plusieurs sources (GET/POST, reference/ref)
$ref = '';
if (isset($_GET['reference']))      $ref = trim((string)$_GET['reference']);
elseif (isset($_GET['ref']))        $ref = trim((string)$_GET['ref']);
elseif (isset($_POST['reference'])) $ref = trim((string)$_POST['reference']);
elseif (isset($_POST['ref']))       $ref = trim((string)$_POST['ref']);

if ($ref === '') {
    http_response_code(400);
    exit('Paramètre manquant : ?reference=XXXX (ou ?ref=XXXX).');
}

$sql = "SELECT reference, designation, quantite, descriptif, prix_unitaire_HT, stock, poids_piece
        FROM produit
        WHERE reference = ?
        LIMIT 1";
$st = $pdo->prepare($sql);
$st->execute([$ref]);
$p = $st->fetch(PDO::FETCH_ASSOC);

if (!$p) {
    http_response_code(404);
    exit("Produit introuvable pour la référence : {$ref}");
}




// 3) HTML du PDF (sobre)
function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
$prix = number_format((float)$p['prix_unitaire_HT'], 2, ',', ' ');

$html = '
<!doctype html>
<html lang="fr"><head><meta charset="utf-8">
<title>Fiche produit '.e($p['reference']).'</title>
<style>
 body{font-family:DejaVu Sans,Arial,sans-serif;font-size:12px;color:#111;}
 h1{font-size:18px;margin:0 0 10px;}
 .meta{font-size:11px;color:#666;margin-bottom:16px;}
 table{width:100%;border-collapse:collapse;}
 th,td{padding:8px 10px;text-align:left;vertical-align:top;}
 th{width:28%;background:#f3f4f6;}
 tr+tr th,tr+tr td{border-top:1px solid #e5e7eb;}
 .right{text-align:right;}
 .footer{margin-top:18px;font-size:10px;color:#6b7280;}
</style></head><body>
<h1>Fiche produit</h1>
<div class="meta">Générée le '.date('d/m/Y H:i').'</div>
<table>
 <tr><th>Référence</th><td>'.e($p['reference']).'</td></tr>
 <tr><th>Désignation</th><td>'.e($p['designation']).'</td></tr>
 <tr><th>Quantité</th><td>'.e($p['quantite']).'</td></tr>
 <tr><th>Descriptif</th><td>'.e($p['descriptif']).'</td></tr>
 <tr><th>Prix unitaire HT</th><td class="right">'.$prix.' €</td></tr>
 <tr><th>Stock</th><td>'.e($p['stock']).'</td></tr>
 <tr><th>Poids pièce</th><td>'.e($p['poids_piece']).'</td></tr>
</table>
<div class="footer">Document interne – '.$_SERVER['HTTP_HOST'].'</div>
</body></html>';

// 4) Dompdf
$opt = new Options();
$opt->set('isRemoteEnabled', true);
$opt->set('defaultFont', 'DejaVu Sans');

$pdf = new Dompdf($opt);
$pdf->loadHtml($html, 'UTF-8');
$pdf->setPaper('A4', 'portrait');
$pdf->render();
$pdf->stream('fiche-produit-'.($p['reference']).'.pdf', ['Attachment' => false]);
