<?php

class HistoriqueTable
{

    private $codec = "";
    private $nom = "";
    private $adresse = "";
    private $cp = "";
    private $ville = "";
    private $telephone = "";

    private $designation = "";

    private $quantite = "";

    private $prixTTC = "";

    private $dateCommande = "";

    private $src = 0;
    private $autorisationBD = "true";

    private $quantite_demandee = "";

    private $numero = "";

    private $codev = "";

    private $NombreJourLivraison = "";

    private $etat = "";



    private static $messageErreur = "";

    private static $messageSucces = "";


    public function __construct($data = null)
    {

        if ($data != null) {

            $this->hydrater($data);
        }


    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            //Concaténation du nom de la clé avec le préfixe set (construction pour l'appel du setter)
            $setter = 'set' . ucfirst($key);
            // appeler une fonction qui me permet de vérifier si la méthode de type setter existe.
            if (method_exists($this, $setter)) {
                // invoquer la méthode correspondante
                $this->$setter($value);
            }
        }
    }

    public function getCodec()
    {
        return $this->codec;
    }

    public function setCodec($codec)
    {
        $this->codec = $codec;
    }

    public function getNom(): string
    {
        return $this->nom;
    }

    public function setNom(string $nom): void
    {
        if (empty($nom) || ctype_space($nom)){

            $this->setAutorisationBD(false);
        self::setMessageErreur("le nom du client est obligatoire.");


    }
        $this->nom = $nom;
    }

    public function getAdresse(): string
    {
        return $this->adresse;
    }

    public function setAdresse(string $adresse): void
    {
        $this->adresse = $adresse;
    }

    public function getCp(): string
    {
        return $this->cp;
    }

    public function setCp(string $cp): void
    {
        if (empty($cp) || ctype_space($cp)){

        $this->setAutorisationBD(false);
        self::setMessageErreur("le code postal du client est obligatoire.");
    }
        $this->cp = $cp;
    }

    public function getVille(): string
    {
        return $this->ville;
    }

    public function setVille(string $ville): void
    {
        $this->ville = $ville;
    }

    public function getTelephone(): string
    {
        return $this->telephone;
    }

    public function setTelephone(string $telephone): void
    {
        $this->telephone = $telephone;
    }

    public function getAutorisationBD(): string
    {
        return $this->autorisationBD;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function getMessageSucces(): string
    {
        return self::$messageSucces;
    }

    public function setAutorisationBD(string $autorisationBD): void
    {
        $this->autorisationBD = $autorisationBD;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur = self::$messageErreur . $messageErreur;    }

    public static function setMessageSucces(string $messageSucces): void
    {
        self::$messageSucces = $messageSucces;
    }

    public function getDesignation(): string
    {
        return $this->designation;
    }

    public function getQuantite(): string
    {
        return $this->quantite;
    }

    public function getPrixTTC(): string
    {
        return $this->prixTTC;
    }

    public function setDesignation(string $designation): void
    {
        $this->designation = $designation;
    }

    public function setQuantite(string $quantite): void
    {
        $this->quantite = $quantite;
    }

    public function setPrixTTC(string $prixTTC): void
    {
        $this->prixTTC = $prixTTC;
    }

    public function getDateCommande(): string
    {
        return $this->dateCommande;
    }

    public function setDateCommande(string $dateCommande): void
    {
        $this->dateCommande = $dateCommande;
    }

    public function setNumero(string $numero): void
    {
        $this->numero = $numero;
    }

    public function setCodev(string $codev): void
    {
        $this->codev = $codev;
    }

    public function setNombreJourLivraison(string $NombreJourLivraison): void
    {
        $this->NombreJourLivraison = $NombreJourLivraison;
    }

    public function setEtat(string $etat): void
    {
        $this->etat = (int) $etat;;
    }


    public function getNumero(): string
    {
        return $this->numero;
    }

    public function getCodev(): string
    {
        return $this->codev;
    }

    public function getNombreJourLivraison(): string
    {
        return $this->NombreJourLivraison;
    }

    public function getEtat(): string
    {
        if ($this->etat === 1) {
            return "Livré ✅";
        } elseif ($this->etat === 0) {
            return "En cours de livraison ...";
        }

        return "État inconnu"; // au cas ou

    }

    public function getQuantiteDemandee(): string
    {
        return $this->quantite_demandee;
    }

    public function setQuantiteDemandee(string $quantite_demandee): void
    {
        $this->quantite_demandee = $quantite_demandee;
    }


    public function getSrc(): string
    {
        if ($this->src === 0) {
            return "Application Vendeur";
        } elseif ($this->src === 1) {
            return "Application Client";
        }

        return "État inconnu"; // au cas ou

    }




}