<?php

class HistoriqueControleur{

    /* Espace déclaration des propriétés */
    private $parametres = []; // Remarque : cette proriété est de type => tableau

    private $oModele; // Remarque : cette proriété est de type => objet
    private $oVue; // Remarque : cette proriété est de type => objet

    /* Constructeur */
    /**
     * @param $parametres // contient les valeurs du tableau $_REQUEST ($_GET et $_POST))
     */
    public function __construct($parametres){
        // Initialisation de la propriété parametres
        $this->parametres = $parametres;

        $this->oModele = new HistoriqueModele($this->parametres);

        $this->oVue = new HistoriqueVue($this->parametres);

    }



    public function lister(){

        $lesHistoriques = $this->oModele->getListeHistoriques();


        $this->oVue->genererAffichageListe($lesHistoriques);

    }

    public function form_consulter(){

        $unHistorique = $this->oModele->getUnHistorique();


        $this->oVue->genererAffichagefiche($unHistorique);

    }

    public function form_ajouter(){

        $prepareHistorique = new HistoriqueTable();

        $this->oVue->genererAffichageFiche($prepareHistorique);

    }
    public function ajouter(){

    //je controle les données en prevenance du formualaire (sasie utilisateur)
    // si problème alors
    // retourne au formulaire d'ajout avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (nouvelle enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new HistoriqueTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->addClient($controlDonnes);
            $this->lister();
        }
    }

    public function form_supprimer(){

        $unHistorique = $this->oModele->getUnHistorique();

        $this->oVue->genererAffichagefiche($unHistorique);

    }
    public function form_modifier(){

        $unHistorique = $this->oModele->getUnHistorique();

        $this->oVue->genererAffichageFiche($unHistorique);

    }

    public function modifier(){

        //je controle les données en prevenance du formualaire (sasie utilisateur)
        // si problème alors
        // retourne au formulaire de modification avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (modification enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new HistoriqueTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->editHistorique($controlDonnes);
            $this->lister();
        }
}
        public function supprimer(){
            //je controle l'identifiant du client , est ce qu'il possède une commande ? '
            // si oui alors
            // retourne au formulaire de suppression
            //message d'erreur : client possède au moins une commande
            //sinon ecriture en BDD (nouvelle supression)
            //retourner la vue sur la liste avec un message de succès
            $controleSuppression = $this->oModele->supressionPossible();

            if($controleSuppression == false){
                HistoriqueTable::setMessageErreur("Impossible de supprimer le client. Celui ci possède au moins une commande.");
                $this->oVue->genererAffichageFiche($this->oModele->getUnHistorique());
            }else{
                $this->oModele->deleteClient();

                $this->lister();
            }
        }

}