<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{$titreVue}</title>
    <meta name="description" content="{$titreVue}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="apple-icon.png">
    <link rel="shortcut icon" href="public/favicon.ico">

    <link rel="stylesheet" href="public/assets/css/normalize.css">
    <link rel="stylesheet" href="public/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="public/assets/css/themify-icons.css">
    <link rel="stylesheet" href="public/assets/css/flag-icon.min.css">
    <link rel="stylesheet" href="public/assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="public/assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <!-- <link rel="stylesheet" href="template/assets/css/bootstrap-select.less"> -->
    <link rel="stylesheet" href="public/assets/scss/style.css">
    <link href="public/assets/css/lib/vector-map/jqvmap.min.css" rel="stylesheet">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>


<!-- Left Panel -->


{include file='public/left.tpl'}

<!-- FIN : Left Panel -->



<!-- Right Panel -->

<div id="right-panel" class="right-panel">

    <!--Header -->

    {include file='public/header.tpl'}

    <!-- FIN : header -->


    <div class="breadcrumbs">
        <div class="col-sm-4">
            <div class="page-header float-left">
                <div class="page-title">
                    <h1> Le goût du chocolat, l’innovation au bout des doigts </h1>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="page-header float-right">
                <div class="page-title">
                    <ol class="breadcrumb text-right">
                        <!-- PLACER LE FIL D'ARIANE -->
                        <li><a href="index.php">Accueil</a></li>
                        <li><a href="index.php?gestion=commande">Commandes</a></li>
                        <li class="active">{$titreVue}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div {if $messageSuccess neq ''} class="alert alert-success" role="alert"{/if}>

        {$messageSuccess}
    </div>

    <div class="content mt-3">
        <div class="animated fadeIn">

            <div class="row">

                <div class="col-md-12">

                    <div class="card">
                        <div class="card-header">
                            <strong class="card-title">{$titrePage}
                                <div {if $messageSuccess neq ''} class="alert alert-success" role="alert"{/if}>
                                    {$messageSuccess}
                                </div>
                            </strong>
                            <div class="card mt-4" style="background-color: #cde0cd; border: 1px solid #000;">
                                <div class="card-body d-flex justify-content-between align-items-center">
                                    <a href="index.php?gestion=commande&action=form_consulter" class="btn btn-link">
                                        👁 Voir le panier
                                    </a>

                                    <div class="d-flex align-items-center">
                                        <label class="mr-2 font-weight-bold">Total TTC (en €) :</label>
                                        <input type="text" id="total-ht" class="form-control form-control-sm mr-4" value="0.00" readonly style="width: 100px;">

                                        <label class="mr-2 font-weight-bold">Quantité d'article(s) :</label>
                                        <input type="text" id="quantite-panier" class="form-control form-control-sm" value="0" readonly style="width: 80px;">
                                    </div>
                                </div>
                            </div>




                        </div>
                        <div class="card-body">

                            <table id="bootstrap-data-table" class="table table-striped table-bordered">
                                <!-- PLACER LA LISTE DES CLIENTS -->
                                <thead>
                                <tr>

                                    <th>Référence</th>
                                    <th>Désignation</th>
                                    <th>Stock</th>
                                    <th>Tarif HT</th>
                                    <th>Prix de vente</th>
                                    <th>Quantité</th>
                                    <th>Prix</th>
                                    <th>Ajouter</th>

                                </tr>
                                </thead>
                                <tbody>
                                {foreach from=$listeDesCommandes item=commande}
                                    <tr>

                                        <td>{$commande->getReference()}</td>
                                        <td>{$commande->getDesignation()}</td>
                                        <td>{$commande->getStock()}</td>
                                        <td>{$commande->getPrix_unitaire_HT()}</td>
                                        <td>{$commande->getCoutTotal()}</td>
                                        <td>
                                            <input type="number" name="quantite[{$commande->getReference()}]" min="0" value="0" class="quantite-input" data-prix="{$commande->getPrix_unitaire_HT()}" />
                                        </td>
                                        <td class="total-ttc">0.00</td>
                                        <td>
                                            <button type="button" class="btn-ajouter" data-reference="{$commande->getReference()}">
                                                <img src="public/images/icones/a16.png" alt="Ajouter">
                                            </button>
                                        </td>

                                        <style>
                                            #bootstrap-data-table th,
                                            #bootstrap-data-table td {
                                                text-align: center;
                                                vertical-align: middle;
                                            }
                                        </style>

                                    </tr>

                                    {foreachelse}
                                    <tr>
                                        <td colspan="7">erreur</td>
                                    </tr>

                                {/foreach}

                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>


            </div> <!-- .animated -->
        </div><!-- .content -->


    </div><!-- /#right-panel -->

    <!-- Right Panel -->
    <script src="public/assets/js/vendor/jquery-2.1.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"></script>
    <script src="public/assets/js/plugins.js"></script>
    <script src="public/assets/js/main.js"></script>


    <script src="public/assets/js/lib/data-table/datatables.min.js"></script>
    <script src="public/assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
    <script src="public/assets/js/lib/data-table/dataTables.buttons.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
    <script src="public/assets/js/lib/data-table/jszip.min.js"></script>
    <script src="public/assets/js/lib/data-table/pdfmake.min.js"></script>
    <script src="public/assets/js/lib/data-table/vfs_fonts.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.html5.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.print.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.colVis.min.js"></script>
    <script src="public/assets/js/lib/data-table/datatables-init.js"></script>


    <script type="text/javascript">
        $(document).ready(function () {
            $('#bootstrap-data-table-export').DataTable();
        });
    </script>
    {literal}
        <script>
            document.addEventListener('DOMContentLoaded', function () {

                let panier = {};

                const quantiteInputs = document.querySelectorAll('.quantite-input');
                const boutonsAjouter = document.querySelectorAll('.btn-ajouter');


                quantiteInputs.forEach(input => {
                    ['input', 'change', 'keyup'].forEach(event => {
                        input.addEventListener(event, function () {
                            const quantite = parseFloat(this.value) || 0;
                            const prix = parseFloat(this.dataset.prix) || 0;
                            const totalTTC = (quantite * prix * 1.2).toFixed(2);
                            this.closest('tr').querySelector('.total-ttc').textContent = totalTTC;
                        });
                    });
                });


                function updatePanierBarre() {
                    let totalTTC = 0;
                    let totalQuantite = 0;

                    Object.keys(panier).forEach(ref => {
                        const row = document.querySelector('button[data-reference="' + ref + '"]').closest('tr');
                        const prix = parseFloat(row.querySelector('.quantite-input').dataset.prix) || 0;
                        const qte = panier[ref];

                        totalTTC += prix * qte * 1.2;
                        totalQuantite += qte;
                    });

                    document.getElementById('total-ht').value = totalTTC.toFixed(2);
                    document.getElementById('quantite-panier').value = totalQuantite;
                }


                boutonsAjouter.forEach(button => {
                    button.addEventListener('click', function () {
                        const ref = this.dataset.reference;
                        const input = this.closest('tr').querySelector('.quantite-input');
                        const quantite = parseInt(input.value) || 0;

                        // ❌ Quantité vide ou 0 → alerte visuelle
                        if (quantite <= 0) {
                            alert("Veuillez saisir une quantité avant d'ajouter.");
                            input.classList.add('is-invalid');
                            setTimeout(() => input.classList.remove('is-invalid'), 1500);
                            return;
                        }


                        panier[ref] = quantite;
                        input.value = 0;
                        this.closest('tr').querySelector('.total-ttc').textContent = "0.00";
                        updatePanierBarre();


                        fetch('index.php?gestion=commande&action=charger_panier', {
                            method: 'POST',
                            headers: { 'Content-Type': 'application/json' },
                            body: JSON.stringify(panier)
                        }).then(() => {
                            // une fois le panier enregistré → on redirige
                            //window.location.href = 'index.php?gestion=commande&action=form_consulter';
                        });
                    });
                });
            });
        </script>
    {/literal}




</body>
<tfoot>

</tfoot>
</html>
