<!doctype html>
<!--[if lt IE 7]>
<html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>
<html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>
<html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{$titreVue}</title>
    <meta name="description" content="{$titreVue}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="apple-icon.png">
    <link rel="shortcut icon" href="public/favicon.ico">

    <link rel="stylesheet" href="public/assets/css/normalize.css">
    <link rel="stylesheet" href="public/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="public/assets/css/themify-icons.css">
    <link rel="stylesheet" href="public/assets/css/flag-icon.min.css">
    <link rel="stylesheet" href="public/assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="public/assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <!-- <link rel="stylesheet" href="template/assets/css/bootstrap-select.less"> -->
    <link rel="stylesheet" href="public/assets/scss/style.css">
    <link href="public/assets/css/lib/vector-map/jqvmap.min.css" rel="stylesheet">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>


<!-- Left Panel -->


{include file='public/left.tpl'}

<!-- FIN : Left Panel -->


<!-- Right Panel -->

<div id="right-panel" class="right-panel">

    <!--Header -->

    {include file='public/header.tpl'}

    <!-- FIN : header -->


    <div class="breadcrumbs">
        <div class="col-sm-4">
            <div class="page-header float-left">
                <div class="page-title">
                    <h1>La gourmandise, ça se partage !</h1>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="page-header float-right">
                <div class="page-title">
                    <ol class="breadcrumb text-right">
                        <li><a href="index.php">Accueil</a></li>
                        <li><a href="index.php?gestion=commande">Commandes</a></li>
                        <li class="active">{$titreVue}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<div {if $messageErreur neq ''}class = "alert alert-danger" role="alert"> {/if}
        {$messageErreur}
</div>
    <div class="content mt-3">
        <div class="animated fadeIn">

            <div class="row">

                <div class="col-md-12">

                    <div class="card">
                        <div class="card-header"><strong>{$titrePage}</strong></div>
                        {if isset($articles) && $articles|@count > 0}
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Référence</th>
                                <th>Désignation</th>
                                <th>Quantité</th>
                                <th>Tarif HT</th>
                                <th>Prix de vente (TTC)</th>
                                <th>Total</th>
                                <th>Modifier</th>
                                <th>Supprimer</th>
                            </tr>
                            </thead>
                            <tbody>
                            {assign var="ligne" value=1}
                            {assign var="totalCommande" value=0}
                            {assign var="totalTVA" value=0}
                            {assign var="marge" value=0}

                            {foreach from=$articles item=article}
                                {assign var="prixTTC" value=$article.tarif*1.2}
                                {assign var="totalLigne" value=$prixTTC*$article.quantite}
                                {assign var="tvaLigne" value=($prixTTC - $article.tarif)*$article.quantite}
                                {assign var="margeLigne" value=($article.montantClient - $article.tarif) * $article.quantite}


                                <tr>
                                    <td>{$ligne}</td>
                                    <td>{$article.reference}</td>
                                    <td>{$article.designation}</td>
                                    <td>
                                        <input type="number" name="quantite[{$article.reference}]" value="{$article.quantite}" min="1" class="form-control form-control-sm" />
                                    </td>
                                    <td>{$article.tarif|number_format:2:".":" "} €</td>
                                    <td>{$prixTTC|number_format:2:".":" "} €</td>
                                    <td>{$totalLigne|number_format:2:".":" "} €</td>

                                    <td>    <form method="post" action="index.php?gestion=commande&action=charger_panier">

                                            <input type="hidden" name="gestion" value="commande">
                                            <input type="hidden" name="action" value="form_modifier">
                                            <input type="hidden" name="reference" value="{$article.reference}">
                                            <input type="image"
                                                   name="btn_consulter"
                                                   src="public/images/icones/m16.png">
                                        </form></td>
                                    <td>
                                        <form method="post" action="index.php?gestion=commande&action=charger_panier">
                                            <input type="hidden" name="gestion" value="commande">
                                            <input type="hidden" name="action" value="form_supprimer">
                                            <input type="hidden" name="reference" value="{$article.reference}">
                                            <input type="image" src="public/images/icones/s16.png" alt="Supprimer" title="Supprimer">
                                        </form>
                                    </td>

                                </tr>

                                {math assign="totalCommande" equation="x + y" x=$totalCommande y=$totalLigne}
                                {math assign="totalTVA" equation="x + y" x=$totalTVA y=$tvaLigne}
                                {math assign="marge" equation="x + y" x=$marge y=$margeLigne}
                                {math assign="ligne" equation="x + 1" x=$ligne}
                            {/foreach}
                            </tbody>
                        </table>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <p><strong>Montant de la commande :</strong> {$totalCommande|number_format:2:".":" "} €</p>
                                <p><strong>Total TVA :</strong> {$totalTVA|number_format:2:".":" "} €</p>
                                <p><strong>Marge brute :</strong> <span style="color:blue">{$marge|number_format:2:".":" "} €</span></p>
                            </div>
                            <div class="col-md-6 text-right">
                                <a href="index.php?gestion=commande" class="btn btn-secondary">Retour à la commande</a>
                                <a href="index.php?gestion=commande&action=form_valider_commande" class="btn btn-primary">Poursuivre</a>
                            </div>
                        </div>
                        {else}
                            <div class="alert alert-warning">Aucun article dans le panier.</div>
                            <div class="col-md-6 text-right">
                                <a href="index.php?gestion=commande" class="btn btn-secondary">Retour à la commande</a>
                            </div>
                        {/if}
                    </div>
                </div>

            </div><!-- .animated -->
        </div><!-- .content -->


    </div><!-- /#right-panel -->

    <!-- Right Panel -->
    <script src="public/assets/js/vendor/jquery-2.1.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"></script>
    <script src="public/assets/js/plugins.js"></script>
    <script src="public/assets/js/main.js"></script>


    <script src="public/assets/js/lib/data-table/datatables.min.js"></script>
    <script src="public/assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
    <script src="public/assets/js/lib/data-table/dataTables.buttons.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
    <script src="public/assets/js/lib/data-table/jszip.min.js"></script>
    <script src="public/assets/js/lib/data-table/pdfmake.min.js"></script>
    <script src="public/assets/js/lib/data-table/vfs_fonts.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.html5.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.print.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.colVis.min.js"></script>
    <script src="public/assets/js/lib/data-table/datatables-init.js"></script>


    <script type="text/javascript">
        $(document).ready(function () {
            $('#bootstrap-data-table-export').DataTable();
        });
    </script>

</body>
</html>
