<!doctype html>
<!--[if lt IE 7]>
<html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>
<html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>
<html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{$titreVue}</title>
    <meta name="description" content="{$titreVue}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="apple-icon.png">
    <link rel="shortcut icon" href="public/favicon.ico">

    <link rel="stylesheet" href="public/assets/css/normalize.css">
    <link rel="stylesheet" href="public/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="public/assets/css/themify-icons.css">
    <link rel="stylesheet" href="public/assets/css/flag-icon.min.css">
    <link rel="stylesheet" href="public/assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="public/assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <!-- <link rel="stylesheet" href="template/assets/css/bootstrap-select.less"> -->
    <link rel="stylesheet" href="public/assets/scss/style.css">
    <link href="public/assets/css/lib/vector-map/jqvmap.min.css" rel="stylesheet">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>


<!-- Left Panel -->


{include file='public/left.tpl'}

<!-- FIN : Left Panel -->


<!-- Right Panel -->

<div id="right-panel" class="right-panel">

    <!--Header -->

    {include file='public/header.tpl'}

    <!-- FIN : header -->

    <div class="breadcrumbs">
        <div class="col-sm-4">
            <div class="page-header float-left">
                <div class="page-title">
                    <h1>La gourmandise, ça se partage !</h1>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="page-header float-right">
                <div class="page-title">
                    <ol class="breadcrumb text-right">
                        <li><a href="index.php">Accueil</a></li>
                        <li><a href="index.php?gestion=commande">Commandes</a></li>
                        <li class="active">{$titreVue}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-4">
    <h2>Validation de la commande</h2>

    <div class="row">
        <!-- Bloc Fiche commande -->
        <div class="col-md-6">
            <div class="box">
                <h5>Fiche Commande : Enregistrement</h5>
                <form method="post" action="index.php">
                    <input type="hidden" name="gestion" value="commande">
                    <input type="hidden" name="action" value="valider_commande">

                    <div class="form-group">
                        <label>Date de la commande :</label>
                        <input type="text" name="date_commande" class="form-control" value="{$dateCommande}" readonly>
                    </div>

                    <div class="form-group">
                        <label>Client :</label>
                        <select name="codec" class="form-control" required>
                            <option value="">-- Choisir --</option>
                            {foreach from=$clients item=cli}
                                <option value="{$cli.codec}">{$cli.nom}</option>
                            {/foreach}
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Vendeur :</label>
                        <input type="text" class="form-control" value="{$vendeur}" readonly>
                    </div>

            </div>
        </div>

        <!-- Bloc État commande -->
        <div class="col-md-6">
            <div class="box">
                <h5>État de la commande</h5>
                <div class="form-group">
                    <label>Date de livraison :</label>
                    <input type="text" class="form-control" name="date_livraison" value="{$dateLivraison}" readonly>
                </div>
                <div class="form-group">
                    <label>Total HT :</label>
                    <input type="text" class="form-control" value="{$totalHT|number_format:2:",":" "} €" readonly>
                </div>
                <div class="form-group">
                    <label>TVA :</label>
                    <input type="text" class="form-control" value="{$tva|number_format:2:",":" "} €" readonly>
                </div>
            </div>
        </div>
    </div>

    <!-- Tableau des lignes de commande -->
    <table class="table table-bordered text-center mt-4">
        <thead>
        <tr>
            <th>#</th>
            <th>Référence</th>
            <th>Désignation</th>
            <th>Quantité</th>
            <th>Total HT</th>
        </tr>
        </thead>
        <tbody>
        {assign var="i" value=1}
        {foreach from=$articles item=art}
            <tr>
                <td>{$i}</td>
                <td>{$art.reference}</td>
                <td>{$art.designation}</td>
                <td>{$art.quantite}</td>
                <td>{($totalHT+$tva)|number_format:2:",":" "} €</td>
            </tr>
            {math assign="i" equation="x+1" x=$i}
        {/foreach}
        </tbody>
    </table>

    <!-- Boutons -->
    <div class="d-flex justify-content-between">
        <a href="index.php?gestion=commande&action=form_consulter" class="btn btn-secondary">⬅ Retour à la commande</a>
        <button type="submit" class="btn btn-primary">Valider ✅</button>

    </div>

    </form>
</div>

<!-- Right Panel -->
<script src="public/assets/js/vendor/jquery-2.1.4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"></script>
<script src="public/assets/js/plugins.js"></script>
<script src="public/assets/js/main.js"></script>


<script src="public/assets/js/lib/data-table/datatables.min.js"></script>
<script src="public/assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
<script src="public/assets/js/lib/data-table/dataTables.buttons.min.js"></script>
<script src="public/assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
<script src="public/assets/js/lib/data-table/jszip.min.js"></script>
<script src="public/assets/js/lib/data-table/pdfmake.min.js"></script>
<script src="public/assets/js/lib/data-table/vfs_fonts.js"></script>
<script src="public/assets/js/lib/data-table/buttons.html5.min.js"></script>
<script src="public/assets/js/lib/data-table/buttons.print.min.js"></script>
<script src="public/assets/js/lib/data-table/buttons.colVis.min.js"></script>
<script src="public/assets/js/lib/data-table/datatables-init.js"></script>


<script type="text/javascript">
    $(document).ready(function () {
        $('#bootstrap-data-table-export').DataTable();
    });
</script>

</body>
</html>
