<?php


class CommandeModele extends Modele
{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres)
    {

        $this->parametres = $parametres;

    }


    public function getListeCommandes()
    {

        $sql = 'SELECT * FROM produit';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($commande = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeCommandes[] = new CommandeTable($commande);

            }

            return $listeCommandes;

        } else {

            return null;
        }
    }

    public function getUnCommande()
    {

        $sql = 'SELECT 
                    reference, 
                    designation, 
                    stock, 
                    prix_unitaire_HT 
                    FROM produit;';


    }

    public function addCommande(CommandeTable $commande)
    {
        $sql = 'INSERT INTO commande(nom,telephone,cp,ville,designation,quantite,src)VALUES(?,?,?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $commande->getNom(),
            $commande->getTelephone(),
            $commande->getCp(),
            $commande->getVille(),
            $commande->getDesignation(),
            $commande->getQuantite(),
            $commande->getSrc(),
        ]);
        if ($idRequete) {
            CommandeTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editClient(ClientTable $client)
    {
        $sql = 'UPDATE client SET nom = ?, adresse = ?, cp = ?, ville = ?, telephone = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
            $client->getCodec(),
        ]);
        if ($idRequete) {
            ClientTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM commande WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        } else {
            return true;
        }
    }

    public function deleteClient()
    {
        $sql = 'DELETE FROM client WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);

        if ($idRequete) {

            ClientTable::setMessageSucces("suppression avec succes");
        }
    }

    public function getProduitByReference($reference)
    {
        $sql = "SELECT reference, designation, prix_unitaire_HT FROM produit WHERE reference = ?";
        $res = $this->executeRequete($sql, [$reference]);
        return $res->fetch(PDO::FETCH_ASSOC);
    }


    public function getListeClients()
    {
        $sql = "SELECT codec, nom FROM client ORDER BY nom";
        $stmt = $this->executeRequete($sql);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function insererCommande($codec, $codev, $dateCommande, $dateLivraison, $totalHT, $totalTVA, $src)
    {
        $sql = "INSERT INTO commande (codec, codev, date_commande, date_livraison, total_HT, total_tva, source) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";

        // Préparation de la requête
        $bd = $this->getBD(); // ✅ Utilisation correcte de la méthode avec D majuscule
        $stmt = $bd->prepare($sql);

        // Exécution avec les paramètres
        $stmt->execute([$codec, $codev, $dateCommande, $dateLivraison, $totalHT, $totalTVA, $src]);

        // Récupération du dernier ID inséré (numéro de commande)
        return $bd->lastInsertId();
    }

    public function insererLigneCommande($numero, $ligne, $reference, $quantite)
    {
        $sql = "INSERT INTO ligne_commande (numero, numero_ligne, reference, quantite_demandee)
            VALUES (?, ?, ?, ?)";
        $this->executeRequete($sql, [$numero, $ligne, $reference, $quantite]);
    }

    public function mettreAJourStock($reference, $quantite)
    {
        $sql = "UPDATE produit SET stock = stock - ? WHERE reference = ?";
        $this->executeRequete($sql, [$quantite, $reference]);
    }

    public function getCodeVendeurByLogin($login)
    {
        $sql = "SELECT codev FROM vendeur WHERE login = ?";
        $stmt = $this->executeRequete($sql, [$login]);
        if ($row = $stmt->fetch()) {
            return $row['codev'];
        }
        return null;
    }
}