<!doctype html>
<!--[if lt IE 7]>
<html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>
<html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>
<html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{$titreVue}</title>
    <meta name="description" content="{$titreVue}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="apple-icon.png">
    <link rel="shortcut icon" href="public/favicon.ico">

    <link rel="stylesheet" href="public/assets/css/normalize.css">
    <link rel="stylesheet" href="public/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="public/assets/css/themify-icons.css">
    <link rel="stylesheet" href="public/assets/css/flag-icon.min.css">
    <link rel="stylesheet" href="public/assets/css/cs-skin-elastic.css">
    <link rel="stylesheet" href="public/assets/css/lib/datatable/dataTables.bootstrap.min.css">
    <!-- <link rel="stylesheet" href="template/assets/css/bootstrap-select.less"> -->
    <link rel="stylesheet" href="public/assets/scss/style.css">
    <link href="public/assets/css/lib/vector-map/jqvmap.min.css" rel="stylesheet">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>


<!-- Left Panel -->


{include file='public/left.tpl'}

<!-- FIN : Left Panel -->


<!-- Right Panel -->

<div id="right-panel" class="right-panel">

    <!--Header -->

    {include file='public/header.tpl'}

    <!-- FIN : header -->


    <div class="breadcrumbs">
        <div class="col-sm-4">
            <div class="page-header float-left">
                <div class="page-title">
                    <h1>La gourmandise, ça se partage !</h1>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="page-header float-right">
                <div class="page-title">
                    <ol class="breadcrumb text-right">
                        <li><a href="index.php">Accueil</a></li>
                        <li><a href="index.php?gestion=client">Clients</a></li>
                        <li class="active">{$titreVue}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
<div {if $messageErreur neq ''}
        <div class="alert alert-danger" role="alert">
            {$messageErreur}
        </div>
    {/if}
</div>
    <div class="content mt-3">
        <div class="animated fadeIn">

            {* CORRECTION : Le message d'erreur doit être dans une "row" pour ne pas casser le design *}
            {if $messageErreur neq ''}
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger" role="alert">
                            {$messageErreur}
                        </div>
                    </div>
                </div>
            {/if}

            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header"><strong>{$titrePage}</strong></div>
                        <form action="index.php" method="POST">

                            <!-- PLACER LE FORMULAIRE EN CONSULTATION -->

                            <input type="hidden" name="gestion" value="client">
                            <input type="hidden" name="action" value="{$action}">

                            <div class="card-body card-block">

                                <!-- Image profil dynamique -->
                                <div class="form-group text-center">
                                    <img id="avatarImage"
                                         class="user-avatar rounded-circle mx-auto d-block"
                                         src="{if isset($unClient)}{$unClient->getAvatar()}{else}public/assets/img/default.png{/if}"
                                         alt="Avatar Client"
                                         width="120">
                                </div>


                            {if $action neq 'ajouter'}

                                <div class="form-group"><label for="codec" class=" form-control-label">Code Client
                                        : </label><input type="text" name="codec" class="form-control" readonly
                                                         value="{$unClient->getCodec()}"></div>
                            {/if}
                                <div class="form-group"><label for="nom" class=" form-control-label">Nom et Prénom <sup class="">(*)</sup>
                                        : </label><input type="text" name="nom" class="form-control"
                                                         value="{$unClient->getNom()}" {$readonly} required></div>
                                <div class="form-group">
                                    <label for="genre" class="form-control-label">Genre <sup>(*)</sup> :</label>
                                    <select name="genre" id="genre" class="form-control" {$readonly} required onchange="updateAvatar()">
                                        <option value="">-- Sélectionner --</option>
                                        <option value="A" {if $unClient->getGenre() == 'A'}selected{/if}>A</option>
                                        <option value="F" {if $unClient->getGenre() == 'F'}selected{/if}>F</option>
                                        <option value="M" {if $unClient->getGenre() == 'M'}selected{/if}>M</option>
                                    </select>
                                </div>
                                <div class="form-group"><label for="adresse" class=" form-control-label">Adresse<sup class="">(*)</sup>
                                        : </label><input type="text" name="adresse" class="form-control"
                                                         value="{$unClient->getAdresse()}" {$readonly} required></div>
                                <div class="form-group"><label for="cp" class=" form-control-label">Code Postal<sup class="">(*)</sup>
                                        : </label><input type="text" name="cp" class="form-control"
                                                         value="{$unClient->getCp()}" {$readonly} required></div>
                                <div class="form-group"><label for="ville" class=" form-control-label">Ville<sup class="">(*)</sup>
                                        : </label><input type="text" name="ville" class="form-control"
                                                         value="{$unClient->getVille()}" {$readonly} required></div>
                                <div class="form-group"><label for="telephone" class=" form-control-label">Téléphone<sup class="">(*)</sup>
                                        : </label><input type="text" name="telephone" class="form-control"
                                                         value="{$unClient->getTelephone()}" {$readonly} required></div>

                            </div>
                            <div class="card-body card-block">
                                <div class="col-md-6"><input type='button' class="btn btn-submit" value='Retour'
                                                             onclick='location.href = "index.php?gestion=client"'></div>
                                <div class="col-md-6 ">

                                    {if $action neq 'consulter'}

                                        <input type="submit"
                                               class="btn btn-submit"
                                               name="btn-valider"
                                               value="{$action|capitalize}">

                                    {/if}


                                </div>
                                <br>
                            </div>


                        </form>
                    </div>
                </div>

                {if $action neq 'ajouter'}

                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header"><strong>Statistiques</strong></div>
                        <div class="card-body card-block">

                                <div class="form-group"><strong>CA Réalisé : {$unClient->getStat01()} €</strong></div>
                                <div class="form-group"><strong>Pourcentage du chiffres d'affaires réalisé : {$unClient->getPourcentageClient()} %</strong></div>
                                <div  class="form-group"><strong>Article le plus commandé : {$unClient->getArticle()} 🏆</strong></div>

                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            {/if}


            </div><!-- .animated -->
        </div><!-- .content -->


    </div><!-- /#right-panel -->

    <!-- Right Panel -->
    <script src="public/assets/js/vendor/jquery-2.1.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"></script>
    <script src="public/assets/js/plugins.js"></script>
    <script src="public/assets/js/main.js"></script>


    <script src="public/assets/js/lib/data-table/datatables.min.js"></script>
    <script src="public/assets/js/lib/data-table/dataTables.bootstrap.min.js"></script>
    <script src="public/assets/js/lib/data-table/dataTables.buttons.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.bootstrap.min.js"></script>
    <script src="public/assets/js/lib/data-table/jszip.min.js"></script>
    <script src="public/assets/js/lib/data-table/pdfmake.min.js"></script>
    <script src="public/assets/js/lib/data-table/vfs_fonts.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.html5.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.print.min.js"></script>
    <script src="public/assets/js/lib/data-table/buttons.colVis.min.js"></script>
    <script src="public/assets/js/lib/data-table/datatables-init.js"></script>


    <script type="text/javascript">
        $(document).ready(function () {
            $('#bootstrap-data-table-export').DataTable();
        });
    </script>
<script>
    function updateAvatar() {
        const genre = document.getElementById('genre').value;
        const avatar = document.getElementById('avatarImage');

        switch (genre) {
            case 'F':
                avatar.src = 'public/images/avatar/7.jpg';
                break;
            case 'M':
                avatar.src = 'public/images/admin.jpg';
                break;
            case 'A':
                avatar.src = 'public/images/avatar/8.jpg';
                break;
            default:
                avatar.src = 'public/images/avatar/8.jpg';
        }
    }

    // Optionnel : mettre à jour l'image au chargement si genre déjà sélectionné
    window.addEventListener('DOMContentLoaded', () => {
        updateAvatar();
    });
</script>

</body>
</html>
