<?php

class ClientTable
{
    private $codec = "";
    private $nom = "";
    private $adresse = "";
    private $cp = "";
    private $ville = "";
    private $avatar = "";
    private $telephone = "";
    private $genre = "";

    // Statistiques
    private $stat01 = "0";
    private $pourcentage_client = "";
    private $article = "";

    // Contrôle et Messages
    private $autorisationBD = true; // Changé en booléen réel
    private static $messageErreur = "";
    private static $messageSucces = "";

    public function __construct($data = null)
    {
        if ($data != null) {
            $this->hydrater($data);
        }
    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            $setter = 'set' . ucfirst($key);
            if (method_exists($this, $setter)) {
                $this->$setter($value);
            }
        }
    }

    // --- GETTERS ---
    public function getCodec() { return $this->codec; }
    public function getNom(): string { return $this->nom; }
    public function getAdresse(): string { return $this->adresse; }
    public function getCp(): string { return $this->cp; }
    public function getVille(): string { return $this->ville; }
    public function getTelephone(): string { return $this->telephone; }
    public function getGenre(): string { return $this->genre; }
    public function getAutorisationBD(): bool { return $this->autorisationBD; }
    public static function getMessageErreur(): string { return self::$messageErreur; }
    public static function getMessageSucces(): string { return self::$messageSucces; }

    // --- SETTERS AVEC VALIDATION ---

    public function setNom(string $nom): void
    {
        if (empty(trim($nom))) {
            $this->setAutorisationBD(false);
            self::setMessageErreur("Le nom du client est obligatoire.<br>");
        }
        $this->nom = $nom;
    }

    public function setAdresse(string $adresse): void
    {
        if (empty(trim($adresse))) {
            $this->setAutorisationBD(false);
            self::setMessageErreur("L'adresse est obligatoire.<br>");
        }
        $this->adresse = $adresse;
    }

    public function setCp(string $cp): void
    {
        if (empty(trim($cp))) {
            $this->setAutorisationBD(false);
            self::setMessageErreur("Le code postal est obligatoire.<br>");
        }
        $this->cp = $cp;
    }

    public function setVille(string $ville): void
    {
        if (empty(trim($ville))) {
            $this->setAutorisationBD(false);
            self::setMessageErreur("La ville est obligatoire.<br>");
        }
        $this->ville = $ville;
    }

    public function setTelephone(string $telephone): void
    {
        if (empty(trim($telephone))) {
            $this->setAutorisationBD(false);
            self::setMessageErreur("Le téléphone est obligatoire.<br>");
        }
        $this->telephone = $telephone;
    }

    public function setGenre(string $genre): void
    {
        if (empty($genre)) {
            $this->setAutorisationBD(false);
            self::setMessageErreur("Le genre est obligatoire.<br>");
        }
        $this->genre = $genre;
    }

    public function setCodec($codec) { $this->codec = $codec; }

    public function setAutorisationBD(bool $autorisationBD): void {
        $this->autorisationBD = $autorisationBD;
    }

    public static function setMessageErreur(string $messageErreur): void {
        self::$messageErreur .= $messageErreur;
    }

    public static function setMessageSucces(string $messageSucces): void {
        self::$messageSucces = $messageSucces;
    }

    // --- AUTRES MÉTHODES ---

    public function getAvatar() {
        if ($this->genre === 'F') {
            return 'public/images/avatar/7.jpg';
        } elseif ($this->genre === 'M') {
            return 'public/images/admin.jpg';
        } else {
            return 'public/images/avatar/8.jpg';
        }
    }

    public function setAvatar($avatar) { $this->avatar = $avatar; }
    public function setStat01($valeur): void { $this->stat01 = $valeur; }
    public function getStat01(): string { return $this->stat01; }
    public function getPourcentageClient(): string { return $this->pourcentage_client; }
    public function setPourcentageClient(string $pourcentage_client): void { $this->pourcentage_client = $pourcentage_client; }
    public function getArticle(): string { return $this->article; }
    public function setArticle(string $article): void { $this->article = $article; }
}