<?php

class ClientControleur{

    /* Espace déclaration des propriétés */
    private $parametres = []; // Remarque : cette proriété est de type => tableau

    private $oModele; // Remarque : cette proriété est de type => objet
    private $oVue; // Remarque : cette proriété est de type => objet

    /* Constructeur */
    /**
     * @param $parametres // contient les valeurs du tableau $_REQUEST ($_GET et $_POST))
     */
    public function __construct($parametres){
        // Initialisation de la propriété parametres
        $this->parametres = $parametres;

        $this->oModele = new ClientModele($this->parametres);

        $this->oVue = new ClientVue($this->parametres);

    }



    public function lister(){

        $lesClients = $this->oModele->getListeClients();


        $this->oVue->genererAffichageListe($lesClients);

    }
    public function form_consulter(){

        $unClient = $this->oModele->getUnClient();

        $this->oModele->stat01($unClient);

        $this->oModele->pourcentage_client($unClient);

        $this->oModele->article($unClient);

        $this->oVue->genererAffichagefiche($unClient);

    }


    public function form_ajouter(){

        $prepareClient = new ClientTable();

        $this->oVue->genererAffichageFiche($prepareClient);

    }
    public function ajouter(){

    //je controle les données en prevenance du formualaire (sasie utilisateur)
    // si problème alors
    // retourne au formulaire d'ajout avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (nouvelle enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new ClientTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->addClient($controlDonnes);
            $this->lister();
        }
    }

    public function form_supprimer(){

        $unClient = $this->oModele->getUnClient();

        $this->oVue->genererAffichagefiche($unClient);

    }
    public function form_modifier(){

        $unClient = $this->oModele->getUnClient();

        $this->oVue->genererAffichageFiche($unClient);

    }

    public function modifier(){

        //je controle les données en prevenance du formualaire (sasie utilisateur)
        // si problème alors
        // retourne au formulaire de modification avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (modification enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new ClientTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->editClient($controlDonnes);
            $this->lister();
        }
}
        public function supprimer(){
            //je controle l'identifiant du client , est ce qu'il possède une commande ? '
            // si oui alors
            // retourne au formulaire de suppression
            //message d'erreur : client possède au moins une commande
            //sinon ecriture en BDD (nouvelle supression)
            //retourner la vue sur la liste avec un message de succès
            $controleSuppression = $this->oModele->supressionPossible();

            if($controleSuppression == false){
                ClientTable::setMessageErreur("Impossible de supprimer le client. Celui ci possède au moins une commande.");
                $this->oVue->genererAffichageFiche($this->oModele->getUnClient());
            }else{
                $this->oModele->deleteClient();

                $this->lister();
            }
        }



}