<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang=""> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang=""> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang=""> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang=""> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>SERAPHIN PARYS</title>
    <meta name="description" content="Sufee Admin - HTML5 Admin Template">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="apple-touch-icon" href="apple-icon.png">
    <link rel="shortcut icon" href="favicon.ico">

    <link rel="stylesheet" href="public/assets/css/normalize.css">
    <link rel="stylesheet" href="public/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="public/assets/css/font-awesome.min.css">
    <link rel="stylesheet" href="public/assets/css/themify-icons.css">
    <link rel="stylesheet" href="public/assets/css/flag-icon.min.css">
    <link rel="stylesheet" href="public/assets/css/cs-skin-elastic.css">
    <!-- <link rel="stylesheet" href="assets/css/bootstrap-select.less"> -->
    <link rel="stylesheet" href="public/assets/scss/style.css">
    <link href="public/assets/css/lib/vector-map/jqvmap.min.css" rel="stylesheet">

    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,600,700,800' rel='stylesheet' type='text/css'>

    <!-- <script type="text/javascript" src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv.min.js"></script> -->

</head>
<body>

<!-- Left Panel -->


<!-- PLACER LE Left Panel -->
{include file='public/left.tpl'}
<!-- FIN : Left Panel -->



<!-- Right Panel -->

<div id="right-panel" class="right-panel">

    <!--Header -->

    <!-- PLACER LE  HEADER -->
    {include file='public/header.tpl'}

    <!-- FIN : header -->

    <!--<div class="breadcrumbs">
        <div class="col-sm-4">
            <div class="page-header float-left">
                <div class="page-title">
                    <h1>Dashboard</h1>
                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="page-header float-right">
                <div class="page-title">
                    <ol class="breadcrumb text-right">
                        <li class="active">Dashboard</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    -->
    <div class="dropdown for-notification" style="position: absolute; top: 20px; right: 400px; z-index: 1000;">
        <button class="btn btn-secondary dropdown-toggle" type="button" id="notification" data-toggle="dropdown">
            <i class="fa fa-bell"></i>
            {if isset($notifications) && $notifications|@count > 0}
                <span class="count bg-danger">{$notifications|@count}</span>
            {/if}
        </button>

        <!-- Boîte élargie -->
        <div class="dropdown-menu" aria-labelledby="notification" style="min-width: 350px; padding: 10px;">
            {if isset($notifications) && $notifications|@count > 0}
                <p class="red">Stock bas détecté</p>
                {foreach from=$notifications item=notif}
                    <div class="dropdown-item media bg-flat-color-5"
                         style="display:flex; justify-content:space-between; align-items:center; padding:8px;">

                        <div>
                            <i class="fa fa-warning"></i>
                            <p style="margin:0; font-weight:bold;">
                                ⚠️ {$notif.designation}
                                <small>(Ref: {$notif.reference|default:'—'})</small>
                            </p>
                            <p style="margin:0;">Stock : {$notif.stock} unités</p>
                        </div>

                        <!-- Bouton Copier -->
                        <button type="button" class="btn btn-sm btn-primary copy-btn"
                                data-reference="{$notif.reference|escape}">
                            Copier
                        </button>
                    </div>
                {/foreach}
            {else}
                <p class="dropdown-item">Aucune alerte de stock</p>
            {/if}
        </div>
    </div>

    <!-- Script -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".copy-btn").forEach(function(button) {
                button.addEventListener("click", function(event) {
                    // Empêche le menu de se refermer
                    event.stopPropagation();

                    const reference = this.getAttribute("data-reference");
                    navigator.clipboard.writeText(reference).then(() => {
                        // Changer couleur + texte
                        this.classList.remove("btn-primary");
                        this.classList.add("btn-success");
                        this.textContent = "Copié !";

                        // Revenir à l'état initial après 2s
                        setTimeout(() => {
                            this.classList.remove("btn-success");
                            this.classList.add("btn-primary");
                            this.textContent = "Copier";
                        }, 5000);
                    });
                });
            });
        });
    </script>

    <div class="row">
        <!-- Widget CA -->
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="stat-widget-one">
                        <div class="stat-icon dib"><i class="fa fa-usd text-success border-success"></i></div>
                        <div class="stat-content dib">
                            <div class="stat-text">Chiffre d'affaires total</div>
                            <div class="stat-digit">{$total_CA|default:"0"}&nbsp;€</div>
                        </div>
                    </div>
                </div>

            </div>
        </div>


        <!-- Widget Nombre de Clients -->
        <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="stat-widget-one">
                        <div class="stat-icon dib"><i class="fa fa-users text-primary border-primary"></i></div>
                        <div class="stat-content dib">
                            <div class="stat-text">Nombre total de clients</div>
                            <div class="stat-digit">{$generer_statttt|default:"0"}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid">
    <div class="content mt-3">
        <div class="row">
            <div class="col-sm-12 col-lg-12">
                <div class="card text-white">
                    <div class="card-body">
                        <h4 class="mb-3">CA mensuel 2023–2025</h4>
                        <div class="graph-container">
                            <canvas id="caMois"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row"> <!-- Encapsule les 3 blocs suivants -->
            <div class="col-sm-6 col-lg-4">
                <div class="card text-white">
                    <div class="card-body">
                        <canvas id="camois1"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-lg-4">
                <div class="card text-white">
                    <div class="card-body">
                        <canvas id="camois3"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-lg-4">
                <div class="card text-white">
                    <div class="card-body">
                        <canvas id="camois2"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>


<script src="public/assets/js/jquery.new.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.3/umd/popper.min.js"></script>
<script src="public/assets/js/plugins.js"></script>
<!--<script src="public/assets/js/main.js"></script>-->


<script src="public/assets/js/lib/chart-js/Chart.bundle.js"></script>
<script src="public/assets/js/dashboard.js"></script>
<script src="public/assets/js/widgets.js"></script>
<script src="public/assets/js/lib/vector-map/jquery.vmap.js"></script>
<script src="public/assets/js/lib/vector-map/jquery.vmap.min.js"></script>
<script src="public/assets/js/lib/vector-map/jquery.vmap.sampledata.js"></script>
<script src="public/assets/js/lib/vector-map/country/jquery.vmap.world.js"></script>
<script src="public/assets/js/chart.js"></script>
<script src="public/assets/js/biblio.js"></script>
    <style>
        /* Cloche + menu */
        .dropdown.for-notification .btn-secondary {
            background-color: #000000 !important;
            border-color: #000000 !important;
            color: #ffffff !important;
        }

        .dropdown.for-notification .dropdown-menu {
            background-color: #000000 !important;
            color: #ffffff;
            border: none;
            padding: 10px 0;
            min-width: 250px;
        }

        .dropdown.for-notification .dropdown-item {
            color: #ffffff !important;
            background-color: transparent;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            font-size: 14px;
            padding: 10px 15px;
        }

        .dropdown.for-notification .dropdown-item:hover {
            background-color: #111111;
        }

        /* Compteur rouge */
        .count.bg-danger {
            background-color: red;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 12px;
            position: absolute;
            top: -5px;
            right: -5px;
        }
    </style>

<script>
    ( function ( $ ) {
        "use strict";

        jQuery( '#vmap' ).vectorMap( {
            map: 'world_en',
            backgroundColor: null,
            color: '#ffffff',
            hoverOpacity: 0.7,
            selectedColor: '#1de9b6',
            enableZoom: true,
            showTooltip: true,
            values: sample_data,
            scaleColors: [ '#1de9b6', '#03a9f5' ],
            normalizeFunction: 'polynomial'
        } );
    } )( jQuery );
</script>

<script>
    window.addEventListener('load', function () {
        const ctx = document.getElementById('caMois');
        if (!ctx) {
            console.error("Canvas #caMois non trouvé");
            return;
        }

        fetch('index.php?gestion=accueil&action=generer_ca_mensuel')
            .then(response => response.json())
            .then(data => {
                const labels = ['Jan', 'Fév', 'Mars', 'Avr', 'Mai', 'Juin', 'Juil', 'Août', 'Sept', 'Oct', 'Nov', 'Déc'];

                const ca2024 = Array(12).fill(0);
                const ca2025 = Array(12).fill(0);

                data.forEach(e => {
                    const i = parseInt(e.mois) - 1;
                    ca2024[i] = parseFloat(e.ca_2024) || 0;
                    ca2025[i] = parseFloat(e.ca_2025) || 0;
                });

                new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: labels,
                        datasets: [
                            {
                                label: '2024',
                                data: ca2024,
                                borderColor: 'rgba(54, 162, 235, 1)',
                                backgroundColor: 'rgba(54, 162, 235, 0.2)',
                                tension: 0.3,
                                fill: true
                            },
                            {
                                label: '2025',
                                data: ca2025,
                                borderColor: 'rgba(255, 99, 132, 1)',
                                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                                tension: 0.3,
                                fill: true
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: { position: 'bottom' },
                            title: {
                                display: true,
                                text: 'CA 2024 vs 2025'
                            },
                            tooltip: {
                                callbacks: {
                                    label: function(ctx) {
                                        return ctx.dataset.label + ' : ' + ctx.raw + ' €';
                                    }
                                }
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });
            })
            .catch(err => {
                console.error("Erreur fetch CA mensuel :", err);
            });
    });
</script>
<style>
    .graph-container {
        height: 250px; /* Ajuste selon la hauteur souhaitée */
        position: relative;
    }

    #caMois {
        height: 100% !important;
        width: 100% !important;
    }
</style>
<style>
    html, body {
        max-width: 100%;
        overflow-x: hidden;
    }

</style>


</body>
</html>

