<?php

class AccueilModele extends Modele
{

    private $parametres = []; // Remarque : cette propriété est de type tableau

    public function __construct($parametres)
    {
        $this->parametres = $parametres;
    }

    public function caMois()
    {
        $sql = "SELECT 
                    DATE_FORMAT(date_commande, '%Y-%m') AS mois,
                    SUM(total_ht) AS total_ht
                FROM 
                    commande
                GROUP BY 
                    DATE_FORMAT(date_commande, '%Y-%m')
                ORDER BY 
                    mois";

        $idRequete = $this->executeRequete($sql);

        // Pour un seul résultat (ce qui n'est pas logique ici) :
        // return $idRequete->fetch(PDO::FETCH_ASSOC);

        // Pour plusieurs lignes (plus adapté ici) :
        return $idRequete->fetchall(PDO::FETCH_ASSOC);
    }

    public function commandeMois()
    {
        $sql = "SELECT DATE_FORMAT(date_commande, '%Y-%m') AS mois, COUNT(*) AS nb_commandes
FROM commande
GROUP BY mois
ORDER BY mois ASC;";

        $idRequete = $this->executeRequete($sql);

        return $idRequete->fetchall(PDO::FETCH_ASSOC);
    }

    public function topClient()
    {
        $sql = "SELECT 
    c.nom AS client,
    SUM(cmd.total_ht) AS ca
FROM 
    commande cmd
JOIN 
    client c ON cmd.codec = c.codec
GROUP BY 
    c.codec
ORDER BY 
    ca DESC
LIMIT 5;";

        $idRequete = $this->executeRequete($sql);

        return $idRequete->fetchall(PDO::FETCH_ASSOC);

    }
    public function totalCA(){
        $sql = "SELECT ROUND(SUM(total_ht + total_tva),2) AS totalCA
        FROM commande;";

        $idRequete = $this->executeRequete($sql);

        return $idRequete->fetch(PDO::FETCH_ASSOC);
    }

    public function nombreTotalClients() {
        $sql = "SELECT COUNT(*) AS total_clients FROM client";
        $idRequete = $this->executeRequete($sql);
        return $idRequete->fetch(PDO::FETCH_ASSOC);
    }

    public function caMensuel() {
        $sql = "SELECT
                MONTH(date_commande) AS mois,
                
                ROUND(SUM(CASE WHEN YEAR(date_commande) = 2024 THEN total_ht + total_tva ELSE 0 END), 2) AS ca_2024,
                ROUND(SUM(CASE WHEN YEAR(date_commande) = 2025 THEN total_ht + total_tva ELSE 0 END), 2) AS ca_2025
            FROM commande
            WHERE YEAR(date_commande) IN (2024, 2025)
            GROUP BY MONTH(date_commande)
            ORDER BY mois";

        $result = $this->executeRequete($sql);
        return $result->fetchAll(PDO::FETCH_ASSOC);
    }

    public function produitsStockBas()
    {
        $sql = "SELECT designation, stock, reference FROM produit WHERE stock < 25";
        $idRequete = $this->executeRequete($sql);
        return $idRequete->fetchAll(PDO::FETCH_ASSOC);
    }


}