<?php

class AccueilTable
{

    private $codec = "";
    private $nom = "";
    private $adresse = "";
    private $cp = "";
    private $ville = "";

    private $avatar = "";

    private $stat01 = "0";
    private $telephone = "";

    private $autorisationBD = "true";

    private $genre = "";

    private static $messageErreur = "";

    private static $messageSucces = "";

    private $totalCA = "";

    private $total_clients = "";

    private $notifications = [];

    public function __construct($data = null)
    {

        if ($data != null) {

            $this->hydrater($data);
        }


    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            //Concaténation du nom de la clé avec le préfixe set (construction pour l'appel du setter)
            $setter = 'set' . ucfirst($key);
            // appeler une fonction qui me permet de vérifier si la méthode de type setter existe.
            if (method_exists($this, $setter)) {
                // invoquer la méthode correspondante
                $this->$setter($value);
            }
        }
    }


    public function getCodec()
    {
        return $this->codec;
    }

    public function setCodec($codec)
    {
        $this->codec = $codec;
    }

    public function getNom(): string
    {
        return $this->nom;
    }

    public function setNom(string $nom): void
    {
        if (empty($nom) || ctype_space($nom)){

            $this->setAutorisationBD(false);
            self::setMessageErreur("le nom du client est obligatoire.");


        }
        $this->nom = $nom;
    }

    public function getAdresse(): string
    {
        return $this->adresse;
    }

    public function setAdresse(string $adresse): void
    {
        $this->adresse = $adresse;
    }

    public function getCp(): string
    {
        return $this->cp;
    }

    public function setCp(string $cp): void
    {
        if (empty($cp) || ctype_space($cp)){

            $this->setAutorisationBD(false);
            self::setMessageErreur("le code postal du client est obligatoire.");
        }
        $this->cp = $cp;
    }

    public function getVille(): string
    {
        return $this->ville;
    }

    public function setVille(string $ville): void
    {
        $this->ville = $ville;
    }

    public function getTelephone(): string
    {
        return $this->telephone;
    }

    public function setTelephone(string $telephone): void
    {
        $this->telephone = $telephone;
    }

    public function getAutorisationBD(): string
    {
        return $this->autorisationBD;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function getMessageSucces(): string
    {
        return self::$messageSucces;
    }

    public function setAutorisationBD(string $autorisationBD): void
    {
        $this->autorisationBD = $autorisationBD;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur = self::$messageErreur . $messageErreur;    }

    public static function setMessageSucces(string $messageSucces): void
    {
        self::$messageSucces = $messageSucces;
    }

    public function setStat01($valeur): void
    {
        $this->stat01 = $valeur;
    }

    public function getStat01(): string
    {
        return $this->stat01;
    }
    public function getGenre(): string
    {
        return $this->genre;
    }
    public function setGenre(string $genre): void
    {
        $this->genre = $genre;
    }

    public function getAvatar(){

        // avatar par défaut selon genre
        if ($this->genre === 'F') {
            return 'public/images/avatar/7.jpg';
        } elseif ($this->genre === 'M') {
            return 'public/images/admin.jpg';
        } else {
            return 'public/images/avatar/8.jpg';
        }
    }

    public function setAvatar($avatar) {
        $this->avatar = $avatar;
    }

    public function getTotalCA(): string
    {
        return $this->totalCA;
    }

    public function setTotalCA(string $totalCA): void
    {
        $this->totalCA = $totalCA;
    }

    public function getTotalClients(): string
    {
        return $this->total_clients;
    }

    public function setTotalClients(string $total_clients): void
    {
        $this->total_clients = $total_clients;
    }

    public function getNotifications(): array
    {
        return $this->notifications;
    }

    public function setNotifications(array $notifications): void
    {
        $this->notifications = $notifications;
    }



}
