<?php

/**
 * Class AccueilControleur
 * Role : controleur du module accueil
 */
class AccueilControleur{

    /* Espace déclaration des propriétés */
    private $parametres = []; // Remarque : cette proriété est de type => tableau
    private $oVue; // Remarque : cette proriété est de type => objet

    private  $oModele;

    /* Constructeur */
    /**
     * @param $parametres // contient les valeurs du tableau $_REQUEST ($_GET et $_POST))
     */
    public function __construct($parametres){
        // Initialisation de la propriété parametres
        $this->parametres = $parametres;

        // Chargement du controleur associé
        //require_once 'mod_accueil/vue/accueilVue.php';
        // Création d'une instance (objet) de type AccueilControleur
        $this->oVue = new AccueilVue($this->parametres);
        $this->oModele = new AccueilModele($this->parametres);
    }



    public function lister()
    {
        // On récupère les produits avec stock < 25
        $notifications = $this->oModele->produitsStockBas();

        // On injecte les notifications directement dans la vue, sans modifier sa méthode
        $this->oVue->setNotifications($notifications);

        // Appel habituel, sans changement
        $this->oVue->genererAffichageListe();
    }


    public function charts(){

        $valeurs = $this->oModele->caMois();
        $this->oVue->genererCaMois($valeurs);
    }

    public function charts_1(){
        $valeurs = $this->oModele->commandeMois();
        $this->oVue->genererCommandeMois($valeurs);
    }
    public function charts_2(){
        $valeurs = $this->oModele->topClient();
        $this->oVue->genererTopClient($valeurs);

    }
    public function charts_3(){
        $valeurs = $this->oModele->totalCA();
        $this->oVue->genererTotalCa($valeurs);
    }


    public function charts_4(){
        $valeurs = $this->oModele->nombreTotalClients();
        $this->oVue->genererTotalClient($valeurs);
    }

    public function charts_5(){
        $valeurs = $this->oModele->caMensuel();
        $this->oVue->genererCaMensuel($valeurs);
    }


}