function genererCaMois() {
    $.ajax({
        url: 'index.php?gestion=accueil&action=generer_stats',
        type: 'GET',
        dataType: 'text',
        success: function(data) {
            data = JSON.parse(data);
            console.log("CA :", data);

            let mois = data.map(function(e) {
                return e['mois'];
            });
            let total_ht = data.map(function(e) {
                return parseFloat(e['total_ht']) || 0; // ✅ sécurité
            });

            new Chart(document.getElementById('camois1'), {
                type: 'bar',
                data: {
                    labels: mois,
                    datasets: [{
                        label: 'Chiffre d\'affaire par mois',
                        data: total_ht,
                        backgroundColor: 'rgba(54, 162, 235, 0.6)',
                        borderColor: 'rgba(54, 162, 235, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            suggestedMin: 0 // ✅ force un axe positif
                        }
                    }
                }
            });
        }
    });
}

function genererCommandeMois() {
    $.ajax({
        url: 'index.php?gestion=accueil&action=generer_stat',
        type: 'GET',
        dataType: 'text',
        success: function(data) {
            data = JSON.parse(data);
            let mois = data.map(e => e['mois']); // ✅ clé correcte
            let nb_commandes = data.map(e => parseInt(e['nb_commandes']) || 0);

            new Chart(document.getElementById('camois2'), {
                type: 'line',
                data: {
                    labels: mois,
                    datasets: [{
                        label: 'Nombre de commandes par mois',
                        data: nb_commandes,
                        fill: true,
                        tension: 0.4,
                        backgroundColor: 'rgba(54, 162, 235, 0.2)',
                        borderColor: 'rgba(54, 162, 235, 1)',
                        pointBackgroundColor: 'rgba(54, 162, 235, 1)',
                        borderWidth: 2,
                        pointRadius: 5
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top'
                        },
                        title: {
                            display: true,
                            text: 'Nombre de commandes par mois'
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
    });
}
function genererTopClient() {
    $.ajax({
        url: 'index.php?gestion=accueil&action=generer_statt',
        type: 'GET',
        dataType: 'text',
        success: function(data) {
            data = JSON.parse(data);
            console.log("TOP CLIENTS:", data);

            const clients = data.map(e => e.client);
            const ca_values = data.map(e => parseFloat(e.ca) || 0);

            new Chart(document.getElementById('camois3'), {
                type: 'pie',
                data: {
                    labels: clients,
                    datasets: [{
                        label: 'Chiffre d\'affaires par client',
                        data: ca_values,
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.6)',   // Rouge
                            'rgba(54, 162, 235, 0.6)',   // Bleu
                            'rgba(255, 206, 86, 0.6)',   // Jaune
                            'rgba(75, 192, 192, 0.6)',   // Vert
                            'rgba(153, 102, 255, 0.6)'   // Violet
                        ],
                        borderColor: [
                            'rgba(255, 99, 132, 1)',
                            'rgba(54, 162, 235, 1)',
                            'rgba(255, 206, 86, 1)',
                            'rgba(75, 192, 192, 1)',
                            'rgba(153, 102, 255, 1)'
                        ],
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: {
                            position: 'right'
                        },
                        title: {
                            display: true,
                            text: 'Répartition du CA (Top 5 clients)'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.raw || 0;
                                    return `${label}: ${value} €`;
                                }
                            }
                        }
                    }
                }
            });
        }
    });
}
function genererCaMensuel() {
    $.ajax({
        url: 'index.php?gestion=accueil&action=generer_ca_mensuel',
        type: 'GET',
        dataType: 'text',
        success: function(response) {
            const data = JSON.parse(response);


            const moisLabels = [
                'Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin',
                'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'
            ];

            const data2023 = Array(12).fill(0);
            const data2024 = Array(12).fill(0);
            const data2025 = Array(12).fill(0);

            data.forEach(e => {
                const i = e.mois - 1;
                data2023[i] = parseFloat(e.ca_2023) || 0;
                data2024[i] = parseFloat(e.ca_2024) || 0;
                data2025[i] = parseFloat(e.ca_2025) || 0;
            });

            new Chart(document.getElementById('caMois'), {
                type: 'line',
                data: {
                    labels: moisLabels,
                    datasets: [
                        {
                            label: '2024',
                            data: data2024,
                            fill: false,
                            borderColor: 'rgba(54, 162, 235, 1)',
                            backgroundColor: 'rgba(54, 162, 235, 0.2)',
                            tension: 0.3
                        },
                        {
                            label: '2025',
                            data: data2025,
                            fill: false,
                            borderColor: 'rgba(255, 206, 86, 1)',
                            backgroundColor: 'rgba(255, 206, 86, 0.2)',
                            tension: 0.3
                        }
                    ]
                },
                options: {
                    responsive: true,
                    plugins: {
                        title: {
                            display: true,
                            text: 'CA mensuel comparé (2024–2025)'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return `${context.dataset.label} : ${context.raw} €`;
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
    });
}


    $(document).ready(function() {
    genererCaMois();
    genererCommandeMois();
    genererTopClient();
    genererCaMensuel();
});
