<?php

class ProfilTable
{

    private $codev = "";
    private $nom = "";
    private $prenom = "";
    private $adresse = "";
    private $cp = "";
    private $ville = "";
    private $telephone = "";
    private $login = "";
    private $motDePasse = "motDePasse";

    private $totalCa = "";

    private $nouveauMotDePasse = "";

    private $confirmNouveauMotDePasse = "";

    private $autorisationBD = "true";



    private static $messageErreur = "";

    private static $messageSucces = "";



    public function __construct($data = null)
    {

        if ($data != null) {

            $this->hydrater($data);
        }


    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            //Concaténation du nom de la clé avec le préfixe set (construction pour l'appel du setter)
            $setter = 'set' . ucfirst($key);
            // appeler une fonction qui me permet de vérifier si la méthode de type setter existe.
            if (method_exists($this, $setter)) {
                // invoquer la méthode correspondante
                $this->$setter($value);
            }
        }
    }

    public function getCodev()
    {
        return $this->codev;
    }

    public function setCodev($codev)
    {
        $this->codev = $codev;
    }

    public function getNom(): string
    {
        return $this->nom;
    }

    public function setNom(string $nom): void
    {
        if (empty($nom) || ctype_space($nom)){

            $this->setAutorisationBD(false);
        self::setMessageErreur("le nom du profil est obligatoire.");


    }
        $this->nom = $nom;
    }
    public function getPrenom(): string
    {
        return $this->prenom;
    }

    public function setPrenom(string $prenom): void
    {
        if (empty($prenom) || ctype_space($prenom)){

            $this->setAutorisationBD(false);
            self::setMessageErreur("le nom du profil est obligatoire.");


        }
        $this->nom = $prenom;
    }

    public function getAdresse(): string
    {
        return $this->adresse;
    }

    public function setAdresse(string $adresse): void
    {
        $this->adresse = $adresse;
    }

    public function getCp(): string
    {
        return $this->cp;
    }

    public function setCp(string $cp): void
    {
        if (empty($cp) || ctype_space($cp)){

        $this->setAutorisationBD(false);
        self::setMessageErreur("le code postal du client est obligatoire.");
    }
        $this->cp = $cp;
    }

    public function getVille(): string
    {
        return $this->ville;
    }

    public function setVille(string $ville): void
    {
        $this->ville = $ville;
    }

    public function getTelephone(): string
    {
        return $this->telephone;
    }

    public function setTelephone(string $telephone): void
    {
        $this->telephone = $telephone;
    }

    public function getAutorisationBD(): string
    {
        return $this->autorisationBD;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function getMessageSucces(): string
    {
        return self::$messageSucces;
    }

    public function setAutorisationBD(string $autorisationBD): void
    {
        $this->autorisationBD = $autorisationBD;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur = self::$messageErreur . $messageErreur;    }

    public static function setMessageSucces(string $messageSucces): void
    {
        self::$messageSucces = $messageSucces;
    }

    public function getLogin(): string
    {
        return $this->login;
    }

    public function getMotDePasse(): string
    {
        return $this->motDePasse;
    }

    public function setLogin(string $login): void
    {
        $this->login = $login;
    }

    public function setMotDePasse(string $motDePasse): void
    {
        $this->motDePasse = $motDePasse;
    }

    public function getNouveauMotDePasse(): string
    {
        return $this->nouveauMotDePasse;
    }

    public function getConfirmNouveauMotDePasse(): string
    {
        return $this->confirmNouveauMotDePasse;
    }

    public function setNouveauMotDePasse(string $nouveauMotDePasse): void
    {
        $this->nouveauMotDePasse = $nouveauMotDePasse;
    }

    public function setConfirmNouveauMotDePasse(string $confirmNouveauMotDePasse): void
    {
        $this->confirmNouveauMotDePasse = $confirmNouveauMotDePasse;
    }

    public function getTotalCa(): string
    {
        return $this->totalCa;
    }

    public function setTotalCa(string $totalCa): void
    {
        $this->totalCa = $totalCa;
    }







}